/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPObject;
import gov.nist.javax.sip.header.SipStatusLine;

public final class StatusLine
extends SIPObject
implements SipStatusLine {
    private static final long serialVersionUID = -4738092215519950414L;
    protected boolean matchStatusClass;
    protected String sipVersion = "SIP/2.0";
    protected int statusCode;
    protected String reasonPhrase = null;

    @Override
    public boolean match(Object matchObj) {
        if (!(matchObj instanceof StatusLine)) {
            return false;
        }
        StatusLine sl = (StatusLine)matchObj;
        if (sl.matchExpression != null) {
            return sl.matchExpression.match(this.encode());
        }
        if (sl.sipVersion != null && !sl.sipVersion.equals(this.sipVersion)) {
            return false;
        }
        if (sl.statusCode != 0) {
            if (this.matchStatusClass) {
                int hiscode = sl.statusCode;
                String codeString = Integer.toString(sl.statusCode);
                String mycode = Integer.toString(this.statusCode);
                if (codeString.charAt(0) != mycode.charAt(0)) {
                    return false;
                }
            } else if (this.statusCode != sl.statusCode) {
                return false;
            }
        }
        if (sl.reasonPhrase == null || this.reasonPhrase == sl.reasonPhrase) {
            return true;
        }
        return this.reasonPhrase.equals(sl.reasonPhrase);
    }

    public void setMatchStatusClass(boolean flag) {
        this.matchStatusClass = flag;
    }

    @Override
    public String encode() {
        String encoding = "SIP/2.0 " + this.statusCode;
        if (this.reasonPhrase != null) {
            encoding = encoding + " " + this.reasonPhrase;
        }
        encoding = encoding + "\r\n";
        return encoding;
    }

    @Override
    public String getSipVersion() {
        return this.sipVersion;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    public void setSipVersion(String s) {
        this.sipVersion = s;
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    @Override
    public String getVersionMajor() {
        if (this.sipVersion == null) {
            return null;
        }
        String major = null;
        boolean slash = false;
        for (int i2 = 0; i2 < this.sipVersion.length(); ++i2) {
            if (this.sipVersion.charAt(i2) == '.') {
                slash = false;
            }
            if (slash) {
                major = major == null ? "" + this.sipVersion.charAt(i2) : major + this.sipVersion.charAt(i2);
            }
            if (this.sipVersion.charAt(i2) != '/') continue;
            slash = true;
        }
        return major;
    }

    @Override
    public String getVersionMinor() {
        if (this.sipVersion == null) {
            return null;
        }
        String minor = null;
        boolean dot = false;
        for (int i2 = 0; i2 < this.sipVersion.length(); ++i2) {
            if (dot) {
                minor = minor == null ? "" + this.sipVersion.charAt(i2) : minor + this.sipVersion.charAt(i2);
            }
            if (this.sipVersion.charAt(i2) != '.') continue;
            dot = true;
        }
        return minor;
    }
}

