/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.javax.sip.UtilsExt;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPResponse;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Utils
implements UtilsExt {
    private static int digesterPoolsSize = 20;
    private static MessageDigest[] digesterPool = new MessageDigest[digesterPoolsSize];
    private static Random rand;
    private static long counter;
    private static int callIDCounter;
    private static String signature;
    private static Utils instance;
    private static final char[] toHex;

    public static Utils getInstance() {
        return instance;
    }

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i2 = 0; i2 < b.length; ++i2) {
            c[pos++] = toHex[b[i2] >> 4 & 0xF];
            c[pos++] = toHex[b[i2] & 0xF];
        }
        return new String(c);
    }

    public static String getQuotedString(String str) {
        return '\"' + str.replace("\"", "\\\"") + '\"';
    }

    protected static String reduceString(String input) {
        String newString = input.toLowerCase();
        int len = newString.length();
        String retval = "";
        for (int i2 = 0; i2 < len; ++i2) {
            if (newString.charAt(i2) == ' ' || newString.charAt(i2) == '\t') continue;
            retval = retval + newString.charAt(i2);
        }
        return retval;
    }

    public static String toUpperCase(String str) {
        return str.toUpperCase(Locale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateCallIdentifier(String address) {
        MessageDigest md;
        long random = rand.nextLong();
        int hash = (int)Math.abs(random % (long)digesterPoolsSize);
        MessageDigest messageDigest = md = digesterPool[hash];
        synchronized (messageDigest) {
            String date = Long.toString(System.nanoTime() + System.currentTimeMillis() + (long)callIDCounter++ + random);
            byte[] cid = md.digest(date.getBytes());
            String cidString = Utils.toHexString(cid);
            return cidString + "@" + address;
        }
    }

    @Override
    public synchronized String generateTag() {
        return Integer.toHexString(rand.nextInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateBranchId() {
        MessageDigest digester;
        long num = rand.nextLong() + counter++ + System.currentTimeMillis() + System.nanoTime();
        int hash = (int)Math.abs(num % (long)digesterPoolsSize);
        MessageDigest messageDigest = digester = digesterPool[hash];
        synchronized (messageDigest) {
            byte[] bid = digester.digest(Long.toString(num).getBytes());
            return "z9hG4bK-" + signature + "-" + Utils.toHexString(bid);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean responseBelongsToUs(SIPResponse response) {
        Via topmostVia = response.getTopmostVia();
        String branch = topmostVia.getBranch();
        if (branch == null) return false;
        if (!branch.startsWith("z9hG4bK-" + signature)) return false;
        return true;
    }

    public static String getSignature() {
        return signature;
    }

    public static void main(String[] args2) {
        final HashSet branchIds = new HashSet();
        ExecutorService e = Executors.newFixedThreadPool(100);
        for (int q = 0; q < 100; ++q) {
            e.execute(new Runnable(){

                @Override
                public void run() {
                    for (int b = 0; b < 1000000; ++b) {
                        String bid = Utils.getInstance().generateBranchId();
                        if (branchIds.contains(bid)) {
                            throw new RuntimeException("Duplicate Branch ID");
                        }
                        branchIds.add(bid);
                    }
                }
            });
        }
        System.out.println("Done!!");
    }

    static {
        counter = 0L;
        instance = new Utils();
        toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            for (int q = 0; q < digesterPoolsSize; ++q) {
                Utils.digesterPool[q] = MessageDigest.getInstance("MD5");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not intialize Digester ", ex);
        }
        rand = new Random(System.nanoTime());
        signature = Utils.toHexString(Integer.toString(Math.abs(rand.nextInt() % 1000)).getBytes());
    }
}

