/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.util;

import com.newrelic.telemetry.Telemetry;
import com.newrelic.telemetry.events.Event;
import com.newrelic.telemetry.logs.Log;
import com.newrelic.telemetry.metrics.Metric;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestWarnings {
    private static final Logger logger = LoggerFactory.getLogger(IngestWarnings.class);
    private static final int MAX_NUMBER_OF_EVENT_ATTRIBUTES = 254;
    private static final int MAX_NUMBER_OF_METRIC_ATTRIBUTES = 100;
    private static final int MAX_NUMBER_OF_LOG_ATTRIBUTES = 254;
    private static final int MAX_ATTRIBUTE_NAME_LENGTH = 255;
    private static final int MAX_ATTRIBUTE_VALUE_LENGTH = 4096;

    public void raiseIngestWarnings(Map<String, Object> attributes, Telemetry dataType) {
        int numberOfAttributes = attributes.size();
        if (dataType instanceof Event && numberOfAttributes > 254) {
            this.warningNumAttributes("Event");
        }
        if (dataType instanceof Metric && numberOfAttributes > 100) {
            this.warningNumAttributes("Metric");
        }
        if (dataType instanceof Log && numberOfAttributes > 254) {
            this.warningNumAttributes("Log");
        }
        for (String attributeName : attributes.keySet()) {
            if (attributeName == null || attributeName.length() <= 255) continue;
            this.attributeNameWarning(attributeName);
        }
        for (String attributeName : attributes.keySet()) {
            String attributeValue;
            if (attributeName == null || !(attributes.get(attributeName) instanceof String) || (attributeValue = attributes.get(attributeName).toString()).length() <= 4096) continue;
            this.attributeValueWarning(attributeValue);
        }
    }

    public void warningNumAttributes(String telemetryType) {
        logger.warn("The number of attributes in this {} is greater than the maximum allowed attributes per {}.", (Object)telemetryType, (Object)telemetryType);
    }

    public void attributeNameWarning(String attributeName) {
        logger.warn("The length of the attribute named {} is greater than the maximum length allowed for an attribute name.", (Object)attributeName);
    }

    public void attributeValueWarning(String attributeValue) {
        logger.warn("The value of the attribute, {}, is greater than the maximum length allowed for an attribute value.", (Object)attributeValue);
    }
}

