/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.spans;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.Response;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.SpanBatchSenderFactory;
import com.newrelic.telemetry.exceptions.ResponseException;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.json.AttributesJson;
import com.newrelic.telemetry.spans.SpanBatch;
import com.newrelic.telemetry.spans.json.SpanBatchMarshaller;
import com.newrelic.telemetry.spans.json.SpanJsonCommonBlockWriter;
import com.newrelic.telemetry.spans.json.SpanJsonTelemetryBlockWriter;
import com.newrelic.telemetry.transport.BatchDataSender;
import com.newrelic.telemetry.util.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanBatchSender {
    private static final String SPANS_PATH = "/trace/v1";
    private static final String DEFAULT_URL = "https://trace-api.newrelic.com";
    private static final String EUROPEAN_URL = "https://trace-api.eu.newrelic.com";
    private static final Logger logger = LoggerFactory.getLogger(SpanBatchSender.class);
    private final SpanBatchMarshaller marshaller;
    private final BatchDataSender sender;

    SpanBatchSender(SpanBatchMarshaller marshaller, BatchDataSender sender) {
        this.marshaller = marshaller;
        this.sender = sender;
    }

    public Response sendBatch(SpanBatch batch) throws ResponseException {
        if (batch == null || batch.size() == 0) {
            logger.debug("Skipped sending a null or empty span batch");
            return new Response(202, "Ignored", "Empty batch");
        }
        logger.debug("Sending a span batch (number of spans: {}) to the New Relic span ingest endpoint)", (Object)batch.size());
        String json = this.marshaller.toJson(batch);
        return this.sender.send(json, batch);
    }

    public static SpanBatchSender create(Supplier<HttpPoster> httpPosterCreator, BaseConfig baseConfig) {
        return SpanBatchSender.create(SpanBatchSenderFactory.fromHttpImplementation(httpPosterCreator).configureWith(baseConfig).build());
    }

    public static SpanBatchSender create(SenderConfiguration configuration) {
        Utils.verifyNonNull(configuration.getApiKey(), "API key cannot be null");
        Utils.verifyNonNull(configuration.getHttpPoster(), "an HttpPoster implementation is required.");
        String userRegion = configuration.getRegion();
        String defaultUrl = "https://trace-api.newrelic.com/trace/v1";
        String endpointUrlToString = configuration.getEndpointUrl().toString();
        URL url = null;
        if (!endpointUrlToString.equals(defaultUrl)) {
            url = configuration.getEndpointUrl();
        } else {
            try {
                url = SpanBatchSender.returnEndpoint(userRegion);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        SpanBatchMarshaller marshaller = new SpanBatchMarshaller(new SpanJsonCommonBlockWriter(new AttributesJson()), new SpanJsonTelemetryBlockWriter(new AttributesJson()));
        BatchDataSender sender = new BatchDataSender(configuration.getHttpPoster(), configuration.getApiKey(), url, configuration.isAuditLoggingEnabled(), configuration.getSecondaryUserAgent(), configuration.useLicenseKey());
        return new SpanBatchSender(marshaller, sender);
    }

    public static URL returnEndpoint(String userRegion) throws MalformedURLException {
        URL url = null;
        if (userRegion.equals("US")) {
            try {
                url = new URL("https://trace-api.newrelic.com/trace/v1");
                return url;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else if (userRegion.equals("EU")) {
            try {
                url = new URL("https://trace-api.eu.newrelic.com/trace/v1");
                return url;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        throw new MalformedURLException("A valid region (EU or US) needs to be added to generate the right endpoint");
    }

    public static SenderConfiguration.SenderConfigurationBuilder configurationBuilder() {
        return SenderConfiguration.builder(DEFAULT_URL, SPANS_PATH);
    }
}

