/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer.transform;

import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.micrometer.transform.AttributesMaker;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class BareMeterTransformer {
    private final Clock clock;
    private final AttributesMaker attributesMaker = new AttributesMaker();

    public BareMeterTransformer(Clock clock) {
        this.clock = clock;
    }

    public Collection<Metric> transform(Meter meter) {
        Meter.Id id = meter.getId();
        long now = this.clock.wallTime();
        return StreamSupport.stream(meter.measure().spliterator(), false).filter(measurement -> Double.isFinite(measurement.getValue())).map(measurement -> new Gauge(id.getName() + "." + measurement.getStatistic().getTagValueRepresentation(), measurement.getValue(), now, this.attributesMaker.make(id, "meter"))).collect(Collectors.toSet());
    }
}

