/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer.json;

import io.micrometer.core.instrument.util.StringEscapeUtils;
import java.util.function.Supplier;

class JsonUtil {
    JsonUtil() {
    }

    static void object(StringBuilder buff, String name, Runnable body) {
        JsonUtil.object(buff, name, body, true);
    }

    static void object(StringBuilder buff, String name, Runnable body, boolean trailingComma) {
        JsonUtil.escQuote(buff, name);
        buff.append(":");
        JsonUtil.object(buff, body, false);
        JsonUtil.trailComma(buff, trailingComma);
    }

    static void object(StringBuilder buff, Runnable body) {
        JsonUtil.object(buff, body, true);
    }

    static void object(StringBuilder buff, Runnable body, boolean trailingComma) {
        buff.append("{");
        body.run();
        buff.append("}");
        JsonUtil.trailComma(buff, trailingComma);
    }

    static void unknownType(StringBuilder buff, String key, Object value) {
        JsonUtil.unknownType(buff, key, value, true);
    }

    static void unknownType(StringBuilder buff, String key, Object value, boolean trailingComma) {
        if (value instanceof Boolean) {
            JsonUtil.kv(buff, key, ((Boolean)value)::toString, trailingComma);
        } else if (value instanceof Number) {
            JsonUtil.number(buff, key, (Number)value, trailingComma);
        } else {
            JsonUtil.string(buff, key, String.valueOf(value), trailingComma);
        }
    }

    static void string(StringBuilder buff, String key, String value) {
        JsonUtil.string(buff, key, value, true);
    }

    static void string(StringBuilder buff, String key, String value, boolean trailingComma) {
        JsonUtil.kv(buff, key, () -> JsonUtil.escQuote(value), trailingComma);
    }

    static void number(StringBuilder buff, String key, Number value) {
        JsonUtil.number(buff, key, value, true);
    }

    static void number(StringBuilder buff, String key, Number value, boolean trailingComma) {
        JsonUtil.kv(buff, key, value::toString, trailingComma);
    }

    private static void kv(StringBuilder buff, String key, Supplier<String> value, boolean trailingComma) {
        JsonUtil.escQuote(buff, key);
        buff.append(":");
        buff.append(value.get());
        JsonUtil.trailComma(buff, trailingComma);
    }

    private static String escQuote(String content) {
        return JsonUtil.quote(StringEscapeUtils.escapeJson(content));
    }

    private static void escQuote(StringBuilder buff, String content) {
        JsonUtil.quote(buff, StringEscapeUtils.escapeJson(content));
    }

    private static void quote(StringBuilder buff, String content) {
        buff.append(JsonUtil.quote(content));
    }

    private static String quote(String content) {
        return "\"" + content + "\"";
    }

    private static void trailComma(StringBuilder buff, boolean trailingComma) {
        if (trailingComma) {
            buff.append(",");
        }
    }
}

