/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.TelemetryClient;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.MetricBatch;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import com.newrelic.telemetry.micrometer.MicrometerHttpPoster;
import com.newrelic.telemetry.micrometer.NewRelicRegistryConfig;
import com.newrelic.telemetry.micrometer.transform.AttributesMaker;
import com.newrelic.telemetry.micrometer.transform.BareMeterTransformer;
import com.newrelic.telemetry.micrometer.transform.CommonCounterTransformer;
import com.newrelic.telemetry.micrometer.transform.CounterAdapter;
import com.newrelic.telemetry.micrometer.transform.DistributionSummaryTransformer;
import com.newrelic.telemetry.micrometer.transform.FunctionCounterAdapter;
import com.newrelic.telemetry.micrometer.transform.FunctionTimerTransformer;
import com.newrelic.telemetry.micrometer.transform.GaugeTransformer;
import com.newrelic.telemetry.micrometer.transform.HistogramGaugeCustomizer;
import com.newrelic.telemetry.micrometer.transform.LongTaskTimerTransformer;
import com.newrelic.telemetry.micrometer.transform.TimeGaugeTransformer;
import com.newrelic.telemetry.micrometer.transform.TimerTransformer;
import com.newrelic.telemetry.micrometer.util.TimeTracker;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepDistributionSummary;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepTimer;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicRegistry
extends StepMeterRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(NewRelicRegistry.class);
    private static final String implementationVersion;
    private final NewRelicRegistryConfig config;
    private final TelemetryClient telemetryClient;
    private final Attributes commonAttributes;
    private final TimeGaugeTransformer timeGaugeTransformer;
    private final GaugeTransformer gaugeTransformer;
    private final TimerTransformer timerTransformer;
    private final FunctionTimerTransformer functionTimerTransformer;
    private final CommonCounterTransformer<Counter> counterTransformer;
    private final LongTaskTimerTransformer longTaskTimerTransformer;
    private final CommonCounterTransformer<FunctionCounter> functionCounterTransformer;
    private final DistributionSummaryTransformer distributionSummaryTransformer;
    private final BareMeterTransformer bareMeterTransformer;
    private final TimeTracker timeTracker;
    private final HistogramGaugeCustomizer histogramCustomizer;

    private NewRelicRegistry(NewRelicRegistryConfig config2, Clock clock, Attributes commonAttributes, AttributesMaker attributesMaker, TimeTracker timeTracker, MetricBatchSender metricBatchSender) {
        this(config2, clock, commonAttributes, new TelemetryClient(metricBatchSender, null, null, null), new TimeGaugeTransformer(new GaugeTransformer(clock, attributesMaker)), new GaugeTransformer(clock, attributesMaker), new TimerTransformer(timeTracker), new FunctionTimerTransformer(timeTracker), new CommonCounterTransformer<Counter>(timeTracker, attributesMaker, CounterAdapter::new), new LongTaskTimerTransformer(clock), new CommonCounterTransformer<FunctionCounter>(timeTracker, attributesMaker, FunctionCounterAdapter::new), new DistributionSummaryTransformer(timeTracker, attributesMaker), new BareMeterTransformer(clock), new HistogramGaugeCustomizer(), timeTracker);
    }

    NewRelicRegistry(NewRelicRegistryConfig config2, Clock clock, Attributes commonAttributes, TelemetryClient telemetryClient, TimeGaugeTransformer timeGaugeTransformer, GaugeTransformer gaugeTransformer, TimerTransformer timerTransformer, FunctionTimerTransformer functionTimerTransformer, CommonCounterTransformer<Counter> counterTransformer, LongTaskTimerTransformer longTaskTimerTransformer, CommonCounterTransformer<FunctionCounter> functionCounterTransformer, DistributionSummaryTransformer distributionSummaryTransformer, BareMeterTransformer bareMeterTransformer, HistogramGaugeCustomizer histogramCustomizer, TimeTracker timeTracker) {
        super(config2, clock);
        this.config = config2;
        this.commonAttributes = commonAttributes.copy().put("instrumentation.provider", "micrometer").put("collector.name", "micrometer-registry-newrelic").put("collector.version", implementationVersion);
        if (config2.serviceName() != null) {
            this.commonAttributes.put("service.name", config2.serviceName());
        }
        this.telemetryClient = telemetryClient;
        this.timeGaugeTransformer = timeGaugeTransformer;
        this.gaugeTransformer = gaugeTransformer;
        this.timerTransformer = timerTransformer;
        this.functionTimerTransformer = functionTimerTransformer;
        this.counterTransformer = counterTransformer;
        this.longTaskTimerTransformer = longTaskTimerTransformer;
        this.functionCounterTransformer = functionCounterTransformer;
        this.distributionSummaryTransformer = distributionSummaryTransformer;
        this.bareMeterTransformer = bareMeterTransformer;
        this.timeTracker = timeTracker;
        this.histogramCustomizer = histogramCustomizer;
    }

    @Override
    public void start(ThreadFactory threadFactory) {
        LOG.info("New Relic Registry: Version " + implementationVersion + " is starting");
        super.start(threadFactory);
    }

    @Override
    public void close() {
        super.close();
        this.telemetryClient.shutdown();
    }

    @Override
    protected void publish() {
        List<List<Meter>> partitionedData = MeterPartition.partition(this, this.config.batchSize());
        for (List<Meter> batch : partitionedData) {
            ArrayList<Metric> metrics = new ArrayList<Metric>();
            batch.forEach(meter -> {
                if (meter instanceof TimeGauge) {
                    metrics.add(this.timeGaugeTransformer.transform((TimeGauge)meter));
                } else if (meter instanceof Gauge) {
                    metrics.add(this.gaugeTransformer.transform((Gauge)meter));
                } else if (meter instanceof Timer) {
                    metrics.addAll(this.timerTransformer.transform((Timer)meter));
                } else if (meter instanceof FunctionTimer) {
                    metrics.addAll(this.functionTimerTransformer.transform((FunctionTimer)meter));
                } else if (meter instanceof Counter) {
                    metrics.add(this.counterTransformer.transform((Counter)meter));
                } else if (meter instanceof DistributionSummary) {
                    metrics.addAll(this.distributionSummaryTransformer.transform((DistributionSummary)meter));
                } else if (meter instanceof LongTaskTimer) {
                    metrics.addAll(this.longTaskTimerTransformer.transform((LongTaskTimer)meter));
                } else if (meter instanceof FunctionCounter) {
                    metrics.add(this.functionCounterTransformer.transform((FunctionCounter)meter));
                } else {
                    metrics.addAll(this.bareMeterTransformer.transform((Meter)meter));
                }
            });
            this.telemetryClient.sendBatch(new MetricBatch((Collection<Metric>)metrics, this.commonAttributes));
        }
        this.timeTracker.tick();
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public static NewRelicRegistryBuilder builder(NewRelicRegistryConfig config2) {
        return new NewRelicRegistryBuilder(config2);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        StepTimer timer = new StepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
        this.histogramCustomizer.registerHistogramGauges(timer, (MeterRegistry)this);
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        StepDistributionSummary summary = new StepDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.config.step().toMillis(), false);
        this.histogramCustomizer.registerHistogramGauges(summary, (MeterRegistry)this);
        return summary;
    }

    static {
        Package thisPackage = NewRelicRegistry.class.getPackage();
        implementationVersion = Optional.ofNullable(thisPackage.getImplementationVersion()).orElse("UnknownVersion");
    }

    public static class NewRelicRegistryBuilder {
        private final NewRelicRegistryConfig config;
        private HttpSender httpSender = new HttpUrlConnectionSender();
        private Attributes commonAttributes = new Attributes();

        public NewRelicRegistryBuilder(NewRelicRegistryConfig config2) {
            this.config = config2;
        }

        public NewRelicRegistryBuilder httpSender(HttpSender httpSender) {
            this.httpSender = httpSender;
            return this;
        }

        public NewRelicRegistryBuilder commonAttributes(Attributes commonAttributes) {
            this.commonAttributes = commonAttributes;
            return this;
        }

        public NewRelicRegistry build() {
            MetricBatchSender metricBatchSender = this.createMetricBatchSender();
            return new NewRelicRegistry(this.config, Clock.SYSTEM, this.commonAttributes, new AttributesMaker(), new TimeTracker(Clock.SYSTEM), metricBatchSender);
        }

        private MetricBatchSender createMetricBatchSender() {
            SenderConfiguration.SenderConfigurationBuilder builder = MetricBatchSender.configurationBuilder().apiKey(this.config.apiKey()).useLicenseKey(this.config.useLicenseKey()).httpPoster(new MicrometerHttpPoster(this.httpSender)).secondaryUserAgent("NewRelic-Micrometer-Exporter/" + implementationVersion).auditLoggingEnabled(this.config.enableAuditMode());
            builder = this.configureEndpoint(builder);
            return MetricBatchSender.create(builder.build());
        }

        private SenderConfiguration.SenderConfigurationBuilder configureEndpoint(SenderConfiguration.SenderConfigurationBuilder builder) {
            if (this.config.uri() == null) {
                return builder;
            }
            try {
                URI uri = URI.create(this.config.uri());
                return builder.endpoint(uri.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid URI for the metric API : " + this.config.uri(), e);
            }
        }
    }
}

