/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.metrics;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.util.Utils;
import java.util.Map;

public final class Count
implements Metric {
    private final String name;
    private final double value;
    private final long startTimeMs;
    private final long endTimeMs;
    private final Map<String, Object> attributes;

    public Count(String name, double value, long startTimeMs, long endTimeMs, Attributes attributes) {
        this.name = Utils.verifyNonNull(name);
        this.value = value;
        this.startTimeMs = startTimeMs;
        this.endTimeMs = endTimeMs;
        this.attributes = Utils.verifyNonNull(attributes).asMap();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public double getValue() {
        return this.value;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getEndTimeMs() {
        return this.endTimeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Count count2 = (Count)o;
        if (Double.compare(count2.getValue(), this.getValue()) != 0) {
            return false;
        }
        if (this.getStartTimeMs() != count2.getStartTimeMs()) {
            return false;
        }
        if (this.getEndTimeMs() != count2.getEndTimeMs()) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(count2.getName()) : count2.getName() != null) {
            return false;
        }
        return this.getAttributes() != null ? this.getAttributes().equals(count2.getAttributes()) : count2.getAttributes() == null;
    }

    public int hashCode() {
        int result2 = this.getName() != null ? this.getName().hashCode() : 0;
        long temp = Double.doubleToLongBits(this.getValue());
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        result2 = 31 * result2 + (int)(this.getStartTimeMs() ^ this.getStartTimeMs() >>> 32);
        result2 = 31 * result2 + (int)(this.getEndTimeMs() ^ this.getEndTimeMs() >>> 32);
        result2 = 31 * result2 + (this.getAttributes() != null ? this.getAttributes().hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "Count{name='" + this.name + '\'' + ", value=" + this.value + ", startTimeMs=" + this.startTimeMs + ", endTimeMs=" + this.endTimeMs + ", attributes=" + this.attributes + '}';
    }
}

