/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.reactivestreams.client.MongoClient;
import java.util.List;
import org.bson.BsonDocument;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class KeyRetriever {
    private final MongoClient client;
    private final MongoNamespace namespace;

    KeyRetriever(MongoClient client2, MongoNamespace namespace) {
        this.client = Assertions.notNull("client", client2);
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public Mono<List<BsonDocument>> find(BsonDocument keyFilter) {
        return Flux.from(this.client.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName(), BsonDocument.class).withReadConcern(ReadConcern.MAJORITY).find(keyFilter)).collectList();
    }
}

