/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.ListIndexesPublisher;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.internal.AggregatePublisherImpl;
import com.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.mongodb.reactivestreams.client.internal.DistinctPublisherImpl;
import com.mongodb.reactivestreams.client.internal.FindPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ListIndexesPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MapReducePublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

final class MongoCollectionImpl<T>
implements MongoCollection<T> {
    private final MongoOperationPublisher<T> mongoOperationPublisher;

    MongoCollectionImpl(MongoOperationPublisher<T> mongoOperationPublisher) {
        this.mongoOperationPublisher = Assertions.notNull("mongoOperationPublisher", mongoOperationPublisher);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.mongoOperationPublisher.getNamespace();
    }

    @Override
    public Class<T> getDocumentClass() {
        return this.mongoOperationPublisher.getDocumentClass();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.mongoOperationPublisher.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.mongoOperationPublisher.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.mongoOperationPublisher.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.mongoOperationPublisher.getReadConcern();
    }

    MongoOperationPublisher<T> getPublisherHelper() {
        return this.mongoOperationPublisher;
    }

    @Override
    public <D> MongoCollection<D> withDocumentClass(Class<D> newDocumentClass) {
        return new MongoCollectionImpl<D>(this.mongoOperationPublisher.withDocumentClass(newDocumentClass));
    }

    @Override
    public MongoCollection<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withCodecRegistry(codecRegistry));
    }

    @Override
    public MongoCollection<T> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withReadPreference(readPreference));
    }

    @Override
    public MongoCollection<T> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withWriteConcern(writeConcern));
    }

    @Override
    public MongoCollection<T> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withReadConcern(readConcern));
    }

    @Override
    public Publisher<Long> estimatedDocumentCount() {
        return this.estimatedDocumentCount(new EstimatedDocumentCountOptions());
    }

    @Override
    public Publisher<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.mongoOperationPublisher.estimatedDocumentCount(options);
    }

    @Override
    public Publisher<Long> countDocuments() {
        return this.countDocuments(new BsonDocument());
    }

    @Override
    public Publisher<Long> countDocuments(Bson filter2) {
        return this.countDocuments(filter2, new CountOptions());
    }

    @Override
    public Publisher<Long> countDocuments(Bson filter2, CountOptions options) {
        return this.mongoOperationPublisher.countDocuments(null, filter2, options);
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession) {
        return this.countDocuments(clientSession, new BsonDocument());
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession, Bson filter2) {
        return this.countDocuments(clientSession, filter2, new CountOptions());
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession, Bson filter2, CountOptions options) {
        return this.mongoOperationPublisher.countDocuments(Assertions.notNull("clientSession", clientSession), filter2, options);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Bson filter2, Class<TResult> resultClass) {
        return new DistinctPublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass), fieldName, filter2);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(ClientSession clientSession, String fieldName, Class<TResult> resultClass) {
        return this.distinct(clientSession, fieldName, new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(ClientSession clientSession, String fieldName, Bson filter2, Class<TResult> resultClass) {
        return new DistinctPublisherImpl<TResult>(Assertions.notNull("clientSession", clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass), fieldName, filter2);
    }

    @Override
    public FindPublisher<T> find() {
        return this.find(new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Class<TResult> resultClass) {
        return this.find(new BsonDocument(), resultClass);
    }

    @Override
    public FindPublisher<T> find(Bson filter2) {
        return this.find(filter2, this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Bson filter2, Class<TResult> resultClass) {
        return new FindPublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass), filter2);
    }

    @Override
    public FindPublisher<T> find(ClientSession clientSession) {
        return this.find(clientSession, new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(ClientSession clientSession, Class<TResult> resultClass) {
        return this.find(clientSession, new BsonDocument(), resultClass);
    }

    @Override
    public FindPublisher<T> find(ClientSession clientSession, Bson filter2) {
        return this.find(clientSession, filter2, this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(ClientSession clientSession, Bson filter2, Class<TResult> resultClass) {
        return new FindPublisherImpl<TResult>(Assertions.notNull("clientSession", clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass), filter2);
    }

    @Override
    public AggregatePublisher<T> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, this.getDocumentClass());
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregatePublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass), pipeline, AggregationLevel.COLLECTION);
    }

    @Override
    public AggregatePublisher<T> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, this.getDocumentClass());
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregatePublisherImpl<TResult>(Assertions.notNull("clientSession", clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass), pipeline, AggregationLevel.COLLECTION);
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl<TResult>(null, this.mongoOperationPublisher, resultClass, pipeline, ChangeStreamLevel.COLLECTION);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl<TResult>(Assertions.notNull("clientSession", clientSession), this.mongoOperationPublisher, resultClass, pipeline, ChangeStreamLevel.COLLECTION);
    }

    @Override
    public MapReducePublisher<T> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, this.getDocumentClass());
    }

    @Override
    public <TResult> MapReducePublisher<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return new MapReducePublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass), mapFunction, reduceFunction);
    }

    @Override
    public MapReducePublisher<T> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction) {
        return this.mapReduce(clientSession, mapFunction, reduceFunction, this.getDocumentClass());
    }

    @Override
    public <TResult> MapReducePublisher<TResult> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return new MapReducePublisherImpl<TResult>(Assertions.notNull("clientSession", clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass), mapFunction, reduceFunction);
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends T>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options) {
        return this.mongoOperationPublisher.bulkWrite(null, requests, options);
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends T>> requests) {
        return this.bulkWrite(clientSession, requests, new BulkWriteOptions());
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options) {
        return this.mongoOperationPublisher.bulkWrite(Assertions.notNull("clientSession", clientSession), requests, options);
    }

    @Override
    public Publisher<InsertOneResult> insertOne(T document) {
        return this.insertOne(document, new InsertOneOptions());
    }

    @Override
    public Publisher<InsertOneResult> insertOne(T document, InsertOneOptions options) {
        return this.mongoOperationPublisher.insertOne(null, document, options);
    }

    @Override
    public Publisher<InsertOneResult> insertOne(ClientSession clientSession, T document) {
        return this.insertOne(clientSession, document, new InsertOneOptions());
    }

    @Override
    public Publisher<InsertOneResult> insertOne(ClientSession clientSession, T document, InsertOneOptions options) {
        return this.mongoOperationPublisher.insertOne(Assertions.notNull("clientSession", clientSession), document, options);
    }

    @Override
    public Publisher<InsertManyResult> insertMany(List<? extends T> documents) {
        return this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public Publisher<InsertManyResult> insertMany(List<? extends T> documents, InsertManyOptions options) {
        return this.mongoOperationPublisher.insertMany(null, documents, options);
    }

    @Override
    public Publisher<InsertManyResult> insertMany(ClientSession clientSession, List<? extends T> documents) {
        return this.insertMany(clientSession, documents, new InsertManyOptions());
    }

    @Override
    public Publisher<InsertManyResult> insertMany(ClientSession clientSession, List<? extends T> documents, InsertManyOptions options) {
        return this.mongoOperationPublisher.insertMany(Assertions.notNull("clientSession", clientSession), documents, options);
    }

    @Override
    public Publisher<DeleteResult> deleteOne(Bson filter2) {
        return this.deleteOne(filter2, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteOne(Bson filter2, DeleteOptions options) {
        return this.mongoOperationPublisher.deleteOne(null, filter2, options);
    }

    @Override
    public Publisher<DeleteResult> deleteOne(ClientSession clientSession, Bson filter2) {
        return this.deleteOne(clientSession, filter2, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteOne(ClientSession clientSession, Bson filter2, DeleteOptions options) {
        return this.mongoOperationPublisher.deleteOne(Assertions.notNull("clientSession", clientSession), filter2, options);
    }

    @Override
    public Publisher<DeleteResult> deleteMany(Bson filter2) {
        return this.deleteMany(filter2, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteMany(Bson filter2, DeleteOptions options) {
        return this.mongoOperationPublisher.deleteMany(null, filter2, options);
    }

    @Override
    public Publisher<DeleteResult> deleteMany(ClientSession clientSession, Bson filter2) {
        return this.deleteMany(clientSession, filter2, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteMany(ClientSession clientSession, Bson filter2, DeleteOptions options) {
        return this.mongoOperationPublisher.deleteMany(Assertions.notNull("clientSession", clientSession), filter2, options);
    }

    @Override
    public Publisher<UpdateResult> replaceOne(Bson filter2, T replacement) {
        return this.replaceOne(filter2, replacement, new ReplaceOptions());
    }

    @Override
    public Publisher<UpdateResult> replaceOne(Bson filter2, T replacement, ReplaceOptions options) {
        return this.mongoOperationPublisher.replaceOne(null, filter2, replacement, options);
    }

    @Override
    public Publisher<UpdateResult> replaceOne(ClientSession clientSession, Bson filter2, T replacement) {
        return this.replaceOne(clientSession, filter2, replacement, new ReplaceOptions());
    }

    @Override
    public Publisher<UpdateResult> replaceOne(ClientSession clientSession, Bson filter2, T replacement, ReplaceOptions options) {
        return this.mongoOperationPublisher.replaceOne(Assertions.notNull("clientSession", clientSession), filter2, replacement, options);
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter2, Bson update) {
        return this.updateOne(filter2, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter2, Bson update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateOne(null, filter2, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter2, Bson update) {
        return this.updateOne(clientSession, filter2, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter2, Bson update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateOne(Assertions.notNull("clientSession", clientSession), filter2, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter2, List<? extends Bson> update) {
        return this.updateOne(filter2, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter2, List<? extends Bson> update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateOne(null, filter2, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter2, List<? extends Bson> update) {
        return this.updateOne(clientSession, filter2, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter2, List<? extends Bson> update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateOne(Assertions.notNull("clientSession", clientSession), filter2, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter2, Bson update) {
        return this.updateMany(filter2, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter2, Bson update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateMany(null, filter2, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter2, Bson update) {
        return this.updateMany(clientSession, filter2, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter2, Bson update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateMany(Assertions.notNull("clientSession", clientSession), filter2, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter2, List<? extends Bson> update) {
        return this.updateMany(filter2, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter2, List<? extends Bson> update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateMany(null, filter2, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter2, List<? extends Bson> update) {
        return this.updateMany(clientSession, filter2, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter2, List<? extends Bson> update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateMany(Assertions.notNull("clientSession", clientSession), filter2, update, options);
    }

    @Override
    public Publisher<T> findOneAndDelete(Bson filter2) {
        return this.findOneAndDelete(filter2, new FindOneAndDeleteOptions());
    }

    @Override
    public Publisher<T> findOneAndDelete(Bson filter2, FindOneAndDeleteOptions options) {
        return this.mongoOperationPublisher.findOneAndDelete(null, filter2, options);
    }

    @Override
    public Publisher<T> findOneAndDelete(ClientSession clientSession, Bson filter2) {
        return this.findOneAndDelete(clientSession, filter2, new FindOneAndDeleteOptions());
    }

    @Override
    public Publisher<T> findOneAndDelete(ClientSession clientSession, Bson filter2, FindOneAndDeleteOptions options) {
        return this.mongoOperationPublisher.findOneAndDelete(Assertions.notNull("clientSession", clientSession), filter2, options);
    }

    @Override
    public Publisher<T> findOneAndReplace(Bson filter2, T replacement) {
        return this.findOneAndReplace(filter2, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Publisher<T> findOneAndReplace(Bson filter2, T replacement, FindOneAndReplaceOptions options) {
        return this.mongoOperationPublisher.findOneAndReplace(null, filter2, replacement, options);
    }

    @Override
    public Publisher<T> findOneAndReplace(ClientSession clientSession, Bson filter2, T replacement) {
        return this.findOneAndReplace(clientSession, filter2, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Publisher<T> findOneAndReplace(ClientSession clientSession, Bson filter2, T replacement, FindOneAndReplaceOptions options) {
        return this.mongoOperationPublisher.findOneAndReplace(Assertions.notNull("clientSession", clientSession), filter2, replacement, options);
    }

    @Override
    public Publisher<T> findOneAndUpdate(Bson filter2, Bson update) {
        return this.findOneAndUpdate(filter2, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<T> findOneAndUpdate(Bson filter2, Bson update, FindOneAndUpdateOptions options) {
        return this.mongoOperationPublisher.findOneAndUpdate(null, filter2, update, options);
    }

    @Override
    public Publisher<T> findOneAndUpdate(ClientSession clientSession, Bson filter2, Bson update) {
        return this.findOneAndUpdate(clientSession, filter2, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<T> findOneAndUpdate(ClientSession clientSession, Bson filter2, Bson update, FindOneAndUpdateOptions options) {
        return this.mongoOperationPublisher.findOneAndUpdate(Assertions.notNull("clientSession", clientSession), filter2, update, options);
    }

    @Override
    public Publisher<T> findOneAndUpdate(Bson filter2, List<? extends Bson> update) {
        return this.findOneAndUpdate(filter2, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<T> findOneAndUpdate(Bson filter2, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.mongoOperationPublisher.findOneAndUpdate(null, filter2, update, options);
    }

    @Override
    public Publisher<T> findOneAndUpdate(ClientSession clientSession, Bson filter2, List<? extends Bson> update) {
        return this.findOneAndUpdate(clientSession, filter2, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<T> findOneAndUpdate(ClientSession clientSession, Bson filter2, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.mongoOperationPublisher.findOneAndUpdate(Assertions.notNull("clientSession", clientSession), filter2, update, options);
    }

    @Override
    public Publisher<Void> drop() {
        return this.mongoOperationPublisher.dropCollection(null, new DropCollectionOptions());
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession) {
        return this.mongoOperationPublisher.dropCollection(Assertions.notNull("clientSession", clientSession), new DropCollectionOptions());
    }

    @Override
    public Publisher<Void> drop(DropCollectionOptions dropCollectionOptions) {
        return this.mongoOperationPublisher.dropCollection(null, dropCollectionOptions);
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession, DropCollectionOptions dropCollectionOptions) {
        return this.mongoOperationPublisher.dropCollection(Assertions.notNull("clientSession", clientSession), dropCollectionOptions);
    }

    @Override
    public Publisher<String> createIndex(Bson key) {
        return this.createIndex(key, new IndexOptions());
    }

    @Override
    public Publisher<String> createIndex(Bson key, IndexOptions options) {
        return this.mongoOperationPublisher.createIndex(null, key, options);
    }

    @Override
    public Publisher<String> createIndex(ClientSession clientSession, Bson key) {
        return this.createIndex(clientSession, key, new IndexOptions());
    }

    @Override
    public Publisher<String> createIndex(ClientSession clientSession, Bson key, IndexOptions options) {
        return this.mongoOperationPublisher.createIndex(Assertions.notNull("clientSession", clientSession), key, options);
    }

    @Override
    public Publisher<String> createIndexes(List<IndexModel> indexes) {
        return this.createIndexes(indexes, new CreateIndexOptions());
    }

    @Override
    public Publisher<String> createIndexes(List<IndexModel> indexes, CreateIndexOptions options) {
        return this.mongoOperationPublisher.createIndexes(null, indexes, options);
    }

    @Override
    public Publisher<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes) {
        return this.createIndexes(clientSession, indexes, new CreateIndexOptions());
    }

    @Override
    public Publisher<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions options) {
        return this.mongoOperationPublisher.createIndexes(Assertions.notNull("clientSession", clientSession), indexes, options);
    }

    @Override
    public ListIndexesPublisher<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesPublisher<TResult> listIndexes(Class<TResult> resultClass) {
        return new ListIndexesPublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass));
    }

    @Override
    public ListIndexesPublisher<Document> listIndexes(ClientSession clientSession) {
        return this.listIndexes(clientSession, Document.class);
    }

    @Override
    public <TResult> ListIndexesPublisher<TResult> listIndexes(ClientSession clientSession, Class<TResult> resultClass) {
        return new ListIndexesPublisherImpl<TResult>(Assertions.notNull("clientSession", clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass));
    }

    @Override
    public Publisher<Void> dropIndex(String indexName) {
        return this.dropIndex(indexName, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(Bson keys2) {
        return this.dropIndex(keys2, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(String indexName, DropIndexOptions dropIndexOptions) {
        return this.mongoOperationPublisher.dropIndex(null, indexName, dropIndexOptions);
    }

    @Override
    public Publisher<Void> dropIndex(Bson keys2, DropIndexOptions dropIndexOptions) {
        return this.mongoOperationPublisher.dropIndex(null, keys2, dropIndexOptions);
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, String indexName) {
        return this.dropIndex(clientSession, indexName, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, Bson keys2) {
        return this.dropIndex(clientSession, keys2, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, String indexName, DropIndexOptions options) {
        return this.mongoOperationPublisher.dropIndex(Assertions.notNull("clientSession", clientSession), indexName, options);
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, Bson keys2, DropIndexOptions options) {
        return this.mongoOperationPublisher.dropIndex(Assertions.notNull("clientSession", clientSession), keys2, options);
    }

    @Override
    public Publisher<Void> dropIndexes() {
        return this.dropIndexes(new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndexes(DropIndexOptions options) {
        return this.mongoOperationPublisher.dropIndexes(null, options);
    }

    @Override
    public Publisher<Void> dropIndexes(ClientSession clientSession) {
        return this.dropIndexes(clientSession, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndexes(ClientSession clientSession, DropIndexOptions options) {
        return this.mongoOperationPublisher.dropIndexes(Assertions.notNull("clientSession", clientSession), options);
    }

    @Override
    public Publisher<Void> renameCollection(MongoNamespace newCollectionNamespace) {
        return this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Publisher<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.mongoOperationPublisher.renameCollection(null, newCollectionNamespace, options);
    }

    @Override
    public Publisher<Void> renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace) {
        return this.renameCollection(clientSession, newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Publisher<Void> renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.mongoOperationPublisher.renameCollection(Assertions.notNull("clientSession", clientSession), newCollectionNamespace, options);
    }
}

