/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.diagnostics.logging.Logger;

public class ErrorHandlingResultCallback<T>
implements SingleResultCallback<T> {
    private final SingleResultCallback<T> wrapped;
    private final Logger logger;

    public static <T> SingleResultCallback<T> errorHandlingCallback(SingleResultCallback<T> callback, Logger logger2) {
        if (callback instanceof ErrorHandlingResultCallback) {
            return callback;
        }
        return new ErrorHandlingResultCallback<T>(callback, logger2);
    }

    ErrorHandlingResultCallback(SingleResultCallback<T> wrapped, Logger logger2) {
        this.wrapped = Assertions.notNull("wrapped", wrapped);
        this.logger = Assertions.notNull("logger", logger2);
    }

    @Override
    public void onResult(T result2, Throwable t) {
        try {
            this.wrapped.onResult(result2, t);
        }
        catch (Throwable e) {
            this.logger.error("Callback onResult call produced an error", e);
        }
    }
}

