/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.scheduler;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.restcomm.media.concurrent.ConcurrentCyclicFIFO;
import org.restcomm.media.scheduler.Clock;
import org.restcomm.media.scheduler.OrderedTaskQueue;
import org.restcomm.media.scheduler.Task;
import org.restcomm.media.scheduler.TaskChain;

public class PriorityQueueScheduler {
    public static final Integer RECEIVER_QUEUE = 0;
    public static final Integer SENDER_QUEUE = 1;
    public static final Integer MANAGEMENT_QUEUE = 2;
    public static final Integer UDP_MANAGER_QUEUE = 3;
    public static final Integer INPUT_QUEUE = 4;
    public static final Integer MIXER_MIX_QUEUE = 5;
    public static final Integer OUTPUT_QUEUE = 6;
    public static final Integer HEARTBEAT_QUEUE = -1;
    private Clock clock;
    protected OrderedTaskQueue[] taskQueues = new OrderedTaskQueue[7];
    protected OrderedTaskQueue[] heartBeatQueue = new OrderedTaskQueue[5];
    private CoreThread coreThread;
    private CriticalThread criticalThread;
    private boolean isActive;
    private Logger logger = LogManager.getLogger(PriorityQueueScheduler.class);
    private ConcurrentCyclicFIFO<Task> waitingTasks = new ConcurrentCyclicFIFO();
    private ConcurrentCyclicFIFO<Task> criticalTasks = new ConcurrentCyclicFIFO();
    private WorkerThread[] workerThreads;
    private CriticalWorkerThread[] criticalWorkerThreads;

    public PriorityQueueScheduler(Clock clock) {
        int i2;
        this.clock = clock;
        for (i2 = 0; i2 < this.taskQueues.length; ++i2) {
            this.taskQueues[i2] = new OrderedTaskQueue();
        }
        for (i2 = 0; i2 < this.heartBeatQueue.length; ++i2) {
            this.heartBeatQueue[i2] = new OrderedTaskQueue();
        }
        this.coreThread = new CoreThread("scheduler-core");
        this.criticalThread = new CriticalThread("scheduler-critical");
        this.workerThreads = new WorkerThread[Runtime.getRuntime().availableProcessors() * 2];
        this.criticalWorkerThreads = new CriticalWorkerThread[Runtime.getRuntime().availableProcessors() / 2];
        for (i2 = 0; i2 < this.workerThreads.length; ++i2) {
            this.workerThreads[i2] = new WorkerThread("scheduler-worker-" + i2);
        }
        for (i2 = 0; i2 < this.criticalWorkerThreads.length; ++i2) {
            this.criticalWorkerThreads[i2] = new CriticalWorkerThread("scheduler-critical-worker-" + i2);
        }
    }

    public PriorityQueueScheduler() {
        this(null);
    }

    public int getPoolSize() {
        return this.workerThreads.length;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void submit(Task task, Integer index) {
        task.activate(false);
        this.taskQueues[index].accept(task);
    }

    public void submitHeatbeat(Task task) {
        task.activate(true);
        this.heartBeatQueue[this.coreThread.runIndex].accept(task);
    }

    public void submit(TaskChain taskChain) {
        taskChain.start();
    }

    public void start() {
        int i2;
        if (this.isActive) {
            return;
        }
        if (this.clock == null) {
            throw new IllegalStateException("Clock is not set");
        }
        this.isActive = true;
        this.logger.info("Starting ");
        this.coreThread.activate();
        this.criticalThread.activate();
        for (i2 = 0; i2 < this.workerThreads.length; ++i2) {
            this.workerThreads[i2].activate();
        }
        for (i2 = 0; i2 < this.criticalWorkerThreads.length; ++i2) {
            this.criticalWorkerThreads[i2].activate();
        }
        this.logger.info("Started ");
    }

    public void stop() {
        int i2;
        int i3;
        if (!this.isActive) {
            return;
        }
        this.coreThread.shutdown();
        this.criticalThread.shutdown();
        for (i3 = 0; i3 < this.workerThreads.length; ++i3) {
            this.workerThreads[i3].shutdown();
        }
        for (i3 = 0; i3 < this.criticalWorkerThreads.length; ++i3) {
            this.criticalWorkerThreads[i3].shutdown();
        }
        try {
            Thread.sleep(40L);
        }
        catch (InterruptedException i4) {
            // empty catch block
        }
        for (i2 = 0; i2 < this.taskQueues.length; ++i2) {
            this.taskQueues[i2].clear();
        }
        for (i2 = 0; i2 < this.heartBeatQueue.length; ++i2) {
            this.heartBeatQueue[i2].clear();
        }
    }

    public double getMissRate() {
        return 0.0;
    }

    public long getWorstExecutionTime() {
        return 0L;
    }

    private class CriticalWorkerThread
    extends Thread {
        private volatile boolean active;
        private Task current;

        public CriticalWorkerThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (this.active) {
                this.current = null;
                while (this.current == null) {
                    try {
                        this.current = (Task)PriorityQueueScheduler.this.criticalTasks.take();
                    }
                    catch (Exception exception) {}
                }
                this.current.run();
                PriorityQueueScheduler.this.criticalThread.notifyCompletion();
            }
        }

        public void activate() {
            this.active = true;
            this.start();
        }

        private void shutdown() {
            this.active = false;
        }
    }

    private class WorkerThread
    extends Thread {
        private volatile boolean active;
        private Task current;

        public WorkerThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (this.active) {
                this.current = null;
                while (this.current == null) {
                    try {
                        this.current = (Task)PriorityQueueScheduler.this.waitingTasks.take();
                    }
                    catch (Exception ex) {
                        PriorityQueueScheduler.this.logger.warn("Could not poll waiting task in timely fashion. Will keep trying.");
                    }
                }
                this.current.run();
                PriorityQueueScheduler.this.coreThread.notifyCompletion();
            }
        }

        public void activate() {
            this.active = true;
            this.start();
        }

        private void shutdown() {
            this.active = false;
        }
    }

    private class CriticalThread
    extends Thread {
        private volatile boolean active;
        private AtomicInteger activeTasksCount;
        private long cycleStart;
        private Object LOCK;

        public CriticalThread(String name) {
            super(name);
            this.activeTasksCount = new AtomicInteger();
            this.cycleStart = 0L;
            this.LOCK = new Object();
        }

        public void activate() {
            this.active = true;
            this.cycleStart = PriorityQueueScheduler.this.clock.getTime();
            this.start();
        }

        public void notifyCompletion() {
            if (this.activeTasksCount.decrementAndGet() == 0) {
                LockSupport.unpark(PriorityQueueScheduler.this.criticalThread);
            }
        }

        @Override
        public void run() {
            while (this.active) {
                this.executeQueue(PriorityQueueScheduler.this.taskQueues[RECEIVER_QUEUE]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                this.executeQueue(PriorityQueueScheduler.this.taskQueues[SENDER_QUEUE]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                long cycleDuration = PriorityQueueScheduler.this.clock.getTime() - this.cycleStart;
                if (cycleDuration < 4000000L) {
                    try {
                        CriticalThread.sleep(4L - cycleDuration / 1000000L, (int)((4000000L - cycleDuration) % 1000000L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.cycleStart += 4000000L;
            }
        }

        private void executeQueue(OrderedTaskQueue currQueue) {
            currQueue.changePool();
            Task t = currQueue.poll();
            while (t != null) {
                this.activeTasksCount.incrementAndGet();
                PriorityQueueScheduler.this.criticalTasks.offer(t);
                t = currQueue.poll();
            }
        }

        private void shutdown() {
            this.active = false;
        }
    }

    private class CoreThread
    extends Thread {
        private volatile boolean active;
        private int currQueue;
        private AtomicInteger activeTasksCount;
        private long cycleStart;
        private int runIndex;
        private Object LOCK;

        public CoreThread(String name) {
            super(name);
            this.currQueue = UDP_MANAGER_QUEUE;
            this.activeTasksCount = new AtomicInteger();
            this.cycleStart = 0L;
            this.runIndex = 0;
            this.LOCK = new Object();
        }

        public void activate() {
            this.active = true;
            this.start();
        }

        public void notifyCompletion() {
            if (this.activeTasksCount.decrementAndGet() == 0) {
                LockSupport.unpark(PriorityQueueScheduler.this.coreThread);
            }
        }

        @Override
        public void run() {
            this.cycleStart = PriorityQueueScheduler.this.clock.getTime();
            while (this.active) {
                long taskStart = this.cycleStart;
                this.currQueue = MANAGEMENT_QUEUE;
                while (this.currQueue <= OUTPUT_QUEUE) {
                    this.executeQueue(PriorityQueueScheduler.this.taskQueues[this.currQueue]);
                    while (this.activeTasksCount.get() != 0) {
                        LockSupport.park();
                    }
                    ++this.currQueue;
                }
                this.executeQueue(PriorityQueueScheduler.this.taskQueues[MANAGEMENT_QUEUE]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                this.runIndex = (this.runIndex + 1) % 5;
                this.executeQueue(PriorityQueueScheduler.this.heartBeatQueue[this.runIndex]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                this.executeQueue(PriorityQueueScheduler.this.taskQueues[MANAGEMENT_QUEUE]);
                while (this.activeTasksCount.get() != 0) {
                    LockSupport.park();
                }
                long cycleDuration = PriorityQueueScheduler.this.clock.getTime() - this.cycleStart;
                if (cycleDuration < 20000000L) {
                    try {
                        CoreThread.sleep(20L - cycleDuration / 1000000L, (int)((20000000L - cycleDuration) % 1000000L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.cycleStart += 20000000L;
            }
        }

        private void executeQueue(OrderedTaskQueue currQueue) {
            currQueue.changePool();
            Task t = currQueue.poll();
            while (t != null) {
                this.activeTasksCount.incrementAndGet();
                PriorityQueueScheduler.this.waitingTasks.offer(t);
                t = currQueue.poll();
            }
        }

        private void shutdown() {
            this.active = false;
        }
    }
}

