/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.transform.stc.AbstractTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.trait.TraitASTTransformation;
import org.codehaus.groovy.transform.trait.Traits;

public class TraitTypeCheckingExtension
extends AbstractTypeCheckingExtension {
    public TraitTypeCheckingExtension(StaticTypeCheckingVisitor typeCheckingVisitor) {
        super(typeCheckingVisitor);
    }

    private static Parameter[] asParameters(ClassNode traitClass, ClassNode[] argumentTypes) {
        ClassNode classType = GenericsUtils.makeClassSafe0(ClassHelper.CLASS_Type, traitClass.asGenericsType());
        Parameter[] parameters = new Parameter[1 + argumentTypes.length];
        parameters[0] = new Parameter(classType, "self");
        for (int i2 = 1; i2 < parameters.length; ++i2) {
            parameters[i2] = new Parameter(argumentTypes[i2 - 1], "p" + i2);
        }
        return parameters;
    }

    @Override
    public List<MethodNode> handleMissingMethod(ClassNode receiver2, String name, ArgumentListExpression argumentList, ClassNode[] argumentTypes, MethodCall call) {
        String[] decomposed = Traits.decomposeSuperCallName(name);
        if (decomposed != null) {
            List<MethodNode> candidates;
            String traitName = decomposed[0];
            String methodName = decomposed[1];
            List<ClassNode> implementedTraits = Traits.findTraits(receiver2);
            ClassNode nextTrait = null;
            for (int i2 = 0; i2 < implementedTraits.size() - 1; ++i2) {
                ClassNode implementedTrait = implementedTraits.get(i2);
                if (!implementedTrait.getName().equals(traitName)) continue;
                nextTrait = implementedTraits.get(i2 + 1);
            }
            ClassNode returnType = ClassHelper.OBJECT_TYPE;
            if (nextTrait != null && (candidates = this.typeCheckingVisitor.findMethod(nextTrait, methodName, argumentTypes)).size() == 1) {
                returnType = candidates.get(0).getReturnType();
            }
            return Collections.singletonList(this.makeDynamic(call, returnType));
        }
        if (call instanceof MethodCallExpression) {
            ClassNode targetClass;
            MethodCallExpression mce = (MethodCallExpression)call;
            ClassNode returnType = (ClassNode)mce.getNodeMetaData(TraitASTTransformation.DO_DYNAMIC);
            if (returnType != null) {
                return Collections.singletonList(this.makeDynamic(call, returnType));
            }
            ClassNode classNode = targetClass = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver2) ? receiver2.getGenericsTypes()[0].getType() : receiver2;
            if (targetClass.getName().endsWith("$Trait$Helper")) {
                targetClass = targetClass.getOuterClass();
            }
            if (Traits.isTrait(targetClass)) {
                for (ClassNode trait : Traits.findTraits(targetClass)) {
                    for (MethodNode method : Traits.findHelper(trait).getDeclaredMethods(name)) {
                        if (!method.isPublic() || !method.isStatic() || !ParameterUtils.parametersCompatible(TraitTypeCheckingExtension.asParameters(trait, argumentTypes), method.getParameters())) continue;
                        return Collections.singletonList(this.makeDynamic(call, method.getReturnType()));
                    }
                }
            }
        }
        return Collections.emptyList();
    }
}

