/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.nosql;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.appender.nosql.NoSqlDatabaseManager;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="NoSql", category="Core", elementType="appender", printObject=true)
public final class NoSqlAppender
extends AbstractDatabaseAppender<NoSqlDatabaseManager<?>> {
    private final String description = this.getName() + "{ manager=" + this.getManager() + " }";

    private NoSqlAppender(String name, Filter filter2, boolean ignoreExceptions, NoSqlDatabaseManager<?> manager) {
        super(name, filter2, ignoreExceptions, manager);
    }

    @Override
    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static NoSqlAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginElement(value="Filter") Filter filter2, @PluginAttribute(value="bufferSize") String bufferSize, @PluginElement(value="NoSqlProvider") NoSqlProvider<?> provider) {
        if (provider == null) {
            LOGGER.error("NoSQL provider not specified for appender [{}].", (Object)name);
            return null;
        }
        int bufferSizeInt = AbstractAppender.parseInt(bufferSize, 0);
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        String managerName = "noSqlManager{ description=" + name + ", bufferSize=" + bufferSizeInt + ", provider=" + provider + " }";
        NoSqlDatabaseManager<?> manager = NoSqlDatabaseManager.getNoSqlDatabaseManager(managerName, bufferSizeInt, provider);
        if (manager == null) {
            return null;
        }
        return new NoSqlAppender(name, filter2, ignoreExceptions, manager);
    }
}

