/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPFileFilters;
import org.apache.commons.net.util.Charsets;

public class FTPListParseEngine {
    private static final FTPFile[] EMPTY_FTP_FILE_ARRAY = new FTPFile[0];
    private List<String> entries = new LinkedList<String>();
    private ListIterator<String> internalIterator = this.entries.listIterator();
    private final FTPFileEntryParser parser;
    private final boolean saveUnparseableEntries;

    public FTPListParseEngine(FTPFileEntryParser parser2) {
        this(parser2, null);
    }

    FTPListParseEngine(FTPFileEntryParser parser2, FTPClientConfig configuration) {
        this.parser = parser2;
        this.saveUnparseableEntries = configuration != null ? configuration.getUnparseableEntries() : false;
    }

    public List<FTPFile> getFileList(FTPFileFilter filter2) {
        return this.entries.stream().map(e -> {
            FTPFile file = this.parser.parseFTPEntry((String)e);
            return file == null && this.saveUnparseableEntries ? new FTPFile((String)e) : file;
        }).filter(filter2::accept).collect(Collectors.toList());
    }

    public FTPFile[] getFiles() throws IOException {
        return this.getFiles(FTPFileFilters.NON_NULL);
    }

    public FTPFile[] getFiles(FTPFileFilter filter2) throws IOException {
        return this.getFileList(filter2).toArray(EMPTY_FTP_FILE_ARRAY);
    }

    public FTPFile[] getNext(int quantityRequested) {
        LinkedList<FTPFile> tmpResults = new LinkedList<FTPFile>();
        for (int count2 = quantityRequested; count2 > 0 && this.internalIterator.hasNext(); --count2) {
            String entry = this.internalIterator.next();
            FTPFile temp = this.parser.parseFTPEntry(entry);
            if (temp == null && this.saveUnparseableEntries) {
                temp = new FTPFile(entry);
            }
            tmpResults.add(temp);
        }
        return tmpResults.toArray(EMPTY_FTP_FILE_ARRAY);
    }

    public FTPFile[] getPrevious(int quantityRequested) {
        LinkedList<FTPFile> tmpResults = new LinkedList<FTPFile>();
        for (int count2 = quantityRequested; count2 > 0 && this.internalIterator.hasPrevious(); --count2) {
            String entry = this.internalIterator.previous();
            FTPFile temp = this.parser.parseFTPEntry(entry);
            if (temp == null && this.saveUnparseableEntries) {
                temp = new FTPFile(entry);
            }
            tmpResults.add(0, temp);
        }
        return tmpResults.toArray(EMPTY_FTP_FILE_ARRAY);
    }

    public boolean hasNext() {
        return this.internalIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this.internalIterator.hasPrevious();
    }

    private void read(InputStream inputStream2, String charsetName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2, Charsets.toCharset(charsetName)));){
            String line = this.parser.readNextEntry(reader);
            while (line != null) {
                this.entries.add(line);
                line = this.parser.readNextEntry(reader);
            }
        }
    }

    @Deprecated
    public void readServerList(InputStream inputStream2) throws IOException {
        this.readServerList(inputStream2, null);
    }

    public void readServerList(InputStream inputStream2, String charsetName) throws IOException {
        this.entries = new LinkedList<String>();
        this.read(inputStream2, charsetName);
        this.parser.preParse(this.entries);
        this.resetIterator();
    }

    public void resetIterator() {
        this.internalIterator = this.entries.listIterator();
    }
}

