/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.sync;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CancellableContinuationKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.internal.ConcurrentLinkedListKt;
import kotlinx.coroutines.internal.ConcurrentLinkedListNode;
import kotlinx.coroutines.internal.Segment;
import kotlinx.coroutines.internal.SegmentOrClosed;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.sync.CancelSemaphoreAcquisitionHandler;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import kotlinx.coroutines.sync.SemaphoreSegment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\b\u0002\u0018\u00002\u00020\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0007\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\t\u001a\u00020\u0006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\bJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0019\u0010\u0014\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00060\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lkotlinx/coroutines/sync/SemaphoreImpl;", "", "permits", "acquiredPermits", "<init>", "(II)V", "", "acquire", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "acquireSlowPath", "Lkotlinx/coroutines/CancellableContinuation;", "cont", "", "addAcquireToQueue", "(Lkotlinx/coroutines/CancellableContinuation;)Z", "release", "()V", "tryAcquire", "()Z", "tryResumeNextFromQueue", "tryResumeAcquire", "getAvailablePermits", "()I", "availablePermits", "Lkotlin/Function1;", "", "onCancellationRelease", "Lkotlin/jvm/functions/Function1;", "I", "kotlinx-coroutines-core", "Lkotlinx/coroutines/sync/Semaphore;"})
final class SemaphoreImpl
implements Semaphore {
    private final int permits;
    @NotNull
    private volatile /* synthetic */ Object head;
    private static final /* synthetic */ AtomicReferenceFieldUpdater head$FU;
    @NotNull
    private volatile /* synthetic */ long deqIdx;
    private static final /* synthetic */ AtomicLongFieldUpdater deqIdx$FU;
    @NotNull
    private volatile /* synthetic */ Object tail;
    private static final /* synthetic */ AtomicReferenceFieldUpdater tail$FU;
    @NotNull
    private volatile /* synthetic */ long enqIdx;
    private static final /* synthetic */ AtomicLongFieldUpdater enqIdx$FU;
    @NotNull
    volatile /* synthetic */ int _availablePermits;
    static final /* synthetic */ AtomicIntegerFieldUpdater _availablePermits$FU;
    @NotNull
    private final Function1<Throwable, Unit> onCancellationRelease;

    public SemaphoreImpl(int permits, int acquiredPermits) {
        this.permits = permits;
        this.deqIdx = 0L;
        this.enqIdx = 0L;
        if (!(this.permits > 0)) {
            boolean $i$a$-require-SemaphoreImpl$32 = false;
            String $i$a$-require-SemaphoreImpl$32 = "Semaphore should have at least 1 permit, but had " + this.permits;
            throw new IllegalArgumentException($i$a$-require-SemaphoreImpl$32.toString());
        }
        if (!(0 <= acquiredPermits ? acquiredPermits <= this.permits : false)) {
            boolean bl = false;
            String string = "The number of acquired permits should be in 0.." + this.permits;
            throw new IllegalArgumentException(string.toString());
        }
        SemaphoreSegment s = new SemaphoreSegment(0L, null, 2);
        this.head = s;
        this.tail = s;
        this._availablePermits = this.permits - acquiredPermits;
        this.onCancellationRelease = new Function1<Throwable, Unit>(this){
            final /* synthetic */ SemaphoreImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable throwable) {
                this.this$0.release();
            }
        };
    }

    @Override
    public int getAvailablePermits() {
        return Math.max(this._availablePermits, 0);
    }

    @Override
    public boolean tryAcquire() {
        int p;
        SemaphoreImpl $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            p = $this$loop$iv._availablePermits;
            boolean bl = false;
            if (p > 0) continue;
            return false;
        } while (!_availablePermits$FU.compareAndSet(this, p, p - 1));
        return true;
    }

    @Override
    @Nullable
    public Object acquire(@NotNull Continuation<? super Unit> $completion) {
        int p = _availablePermits$FU.getAndDecrement(this);
        if (p > 0) {
            return Unit.INSTANCE;
        }
        Object object = this.acquireSlowPath($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object acquireSlowPath(Continuation<? super Unit> $completion) {
        boolean $i$f$suspendCancellableCoroutineReusable = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl<? super Unit> cancellable$iv = CancellableContinuationKt.getOrCreateCancellableContinuation(IntrinsicsKt.intercepted(uCont$iv));
        CancellableContinuation cont = cancellable$iv;
        boolean bl2 = false;
        while (!this.addAcquireToQueue(cont)) {
            int p = _availablePermits$FU.getAndDecrement(this);
            if (p <= 0) continue;
            cont.resume(Unit.INSTANCE, this.onCancellationRelease);
            break;
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void release() {
        do {
            int cur;
            int upd$iv;
            int cur$iv;
            SemaphoreImpl $this$getAndUpdate$iv = this;
            boolean $i$f$getAndUpdate = false;
            do {
                cur = cur$iv = $this$getAndUpdate$iv._availablePermits;
                boolean bl = false;
                if (cur < this.permits) continue;
                boolean bl2 = false;
                String string = "The number of released permits cannot be greater than " + this.permits;
                throw new IllegalStateException(string.toString());
            } while (!_availablePermits$FU.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = cur + 1));
            int p = cur$iv;
            if (p < 0) continue;
            return;
        } while (!this.tryResumeNextFromQueue());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addAcquireToQueue(CancellableContinuation<? super Unit> cont) {
        Object $this$asHandler$iv;
        void this_$iv;
        Object s$iv;
        boolean bl;
        SemaphoreSegment curTail = (SemaphoreSegment)this.tail;
        long enqIdx = enqIdx$FU.getAndIncrement(this);
        SemaphoreImpl semaphoreImpl = this;
        long id$iv22 = enqIdx / (long)SemaphoreKt.access$getSEGMENT_SIZE$p();
        boolean $i$f$findSegmentAndMoveForward = false;
        block0: do {
            void $this$moveForward$iv$iv;
            void $this$findSegmentAndMoveForward$iv;
            Segment $this$findSegmentInternal$iv$iv;
            block14: {
                Object object;
                $this$findSegmentInternal$iv$iv = curTail;
                boolean $i$f$findSegmentInternal = false;
                Segment cur$iv$iv = $this$findSegmentInternal$iv$iv;
                while (cur$iv$iv.getId() < id$iv22 || cur$iv$iv.getRemoved()) {
                    void p1;
                    ConcurrentLinkedListNode this_$iv$iv$iv = cur$iv$iv;
                    boolean $i$f$nextOrIfClosed = false;
                    Object it$iv$iv$iv = ConcurrentLinkedListNode.access$getNextOrClosed(this_$iv$iv$iv);
                    boolean bl2 = false;
                    if (it$iv$iv$iv == ConcurrentLinkedListKt.access$getCLOSED$p()) {
                        boolean bl3 = false;
                        object = SegmentOrClosed.constructor-impl(ConcurrentLinkedListKt.access$getCLOSED$p());
                        break block14;
                    }
                    Segment next$iv$iv = (Segment)((ConcurrentLinkedListNode)it$iv$iv$iv);
                    if (next$iv$iv != null) {
                        cur$iv$iv = next$iv$iv;
                        continue;
                    }
                    SemaphoreSegment semaphoreSegment = (SemaphoreSegment)cur$iv$iv;
                    long p0 = cur$iv$iv.getId() + 1L;
                    boolean bl4 = false;
                    Segment newTail$iv$iv = SemaphoreKt.access$createSegment(p0, (SemaphoreSegment)p1);
                    if (!cur$iv$iv.trySetNext((ConcurrentLinkedListNode)newTail$iv$iv)) continue;
                    if (cur$iv$iv.getRemoved()) {
                        cur$iv$iv.remove();
                    }
                    cur$iv$iv = newTail$iv$iv;
                }
                object = s$iv = SegmentOrClosed.constructor-impl(cur$iv$iv);
            }
            if (SegmentOrClosed.isClosed-impl(s$iv)) break;
            $this$findSegmentInternal$iv$iv = $this$findSegmentAndMoveForward$iv;
            Object to$iv$iv = SegmentOrClosed.getSegment-impl(s$iv);
            boolean $i$f$moveForward = false;
            void $this$loop$iv$iv$iv = $this$moveForward$iv$iv;
            boolean $i$f$loop = false;
            while (true) {
                Segment cur$iv$iv = (Segment)$this$loop$iv$iv$iv.tail;
                boolean bl5 = false;
                if (cur$iv$iv.getId() >= ((Segment)to$iv$iv).getId()) {
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).tryIncPointers$kotlinx_coroutines_core()) {
                    bl = false;
                    continue block0;
                }
                if (tail$FU.compareAndSet($this$moveForward$iv$iv, cur$iv$iv, to$iv$iv)) {
                    if (cur$iv$iv.decPointers$kotlinx_coroutines_core()) {
                        cur$iv$iv.remove();
                    }
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).decPointers$kotlinx_coroutines_core()) continue;
                ((ConcurrentLinkedListNode)to$iv$iv).remove();
            }
        } while (!bl);
        SemaphoreSegment segment = (SemaphoreSegment)SegmentOrClosed.getSegment-impl(s$iv);
        int i2 = (int)(enqIdx % (long)SemaphoreKt.access$getSEGMENT_SIZE$p());
        SemaphoreSegment id$iv22 = segment;
        Object expected$iv = null;
        boolean $i$f$cas = false;
        if (this_$iv.acquirers.compareAndSet(i2, expected$iv, cont)) {
            $this$asHandler$iv = new CancelSemaphoreAcquisitionHandler(segment, i2);
            boolean $i$f$getAsHandler = false;
            cont.invokeOnCancellation((Function1)$this$asHandler$iv);
            return true;
        }
        $this$asHandler$iv = segment;
        Symbol $i$f$getAsHandler = SemaphoreKt.access$getPERMIT$p();
        Symbol value$iv = SemaphoreKt.access$getTAKEN$p();
        boolean $i$f$cas2 = false;
        if (this_$iv.acquirers.compareAndSet(i2, expected$iv, value$iv)) {
            cont.resume(Unit.INSTANCE, this.onCancellationRelease);
            return true;
        }
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl6 = false;
            SemaphoreSegment this_$iv2 = segment;
            boolean $i$f$get = false;
            if (!(this_$iv2.acquirers.get(i2) == SemaphoreKt.access$getBROKEN$p())) {
                throw new AssertionError();
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryResumeNextFromQueue() {
        void this_$iv222;
        SemaphoreSegment $this$moveForward$iv$iv;
        Object s$iv;
        boolean bl;
        SemaphoreSegment curHead = (SemaphoreSegment)this.head;
        long deqIdx = deqIdx$FU.getAndIncrement(this);
        long id = deqIdx / (long)SemaphoreKt.access$getSEGMENT_SIZE$p();
        SemaphoreImpl $this$findSegmentAndMoveForward$iv = this;
        boolean $i$f$findSegmentAndMoveForward = false;
        block0: do {
            Object $this$findSegmentInternal$iv$iv;
            block14: {
                Object object;
                $this$findSegmentInternal$iv$iv = curHead;
                boolean $i$f$findSegmentInternal = false;
                Segment cur$iv$iv = $this$findSegmentInternal$iv$iv;
                while (cur$iv$iv.getId() < id || cur$iv$iv.getRemoved()) {
                    void p1;
                    ConcurrentLinkedListNode this_$iv$iv$iv = cur$iv$iv;
                    boolean $i$f$nextOrIfClosed = false;
                    Object it$iv$iv$iv = ConcurrentLinkedListNode.access$getNextOrClosed(this_$iv$iv$iv);
                    boolean bl2 = false;
                    if (it$iv$iv$iv == ConcurrentLinkedListKt.access$getCLOSED$p()) {
                        boolean bl3 = false;
                        object = SegmentOrClosed.constructor-impl(ConcurrentLinkedListKt.access$getCLOSED$p());
                        break block14;
                    }
                    Segment next$iv$iv = (Segment)((ConcurrentLinkedListNode)it$iv$iv$iv);
                    if (next$iv$iv != null) {
                        cur$iv$iv = next$iv$iv;
                        continue;
                    }
                    SemaphoreSegment semaphoreSegment = (SemaphoreSegment)cur$iv$iv;
                    long p0 = cur$iv$iv.getId() + 1L;
                    boolean bl4 = false;
                    Segment newTail$iv$iv = SemaphoreKt.access$createSegment(p0, (SemaphoreSegment)p1);
                    if (!cur$iv$iv.trySetNext((ConcurrentLinkedListNode)newTail$iv$iv)) continue;
                    if (cur$iv$iv.getRemoved()) {
                        cur$iv$iv.remove();
                    }
                    cur$iv$iv = newTail$iv$iv;
                }
                object = s$iv = SegmentOrClosed.constructor-impl(cur$iv$iv);
            }
            if (SegmentOrClosed.isClosed-impl(s$iv)) break;
            $this$findSegmentInternal$iv$iv = $this$findSegmentAndMoveForward$iv;
            Object to$iv$iv = SegmentOrClosed.getSegment-impl(s$iv);
            boolean $i$f$moveForward = false;
            void $this$loop$iv$iv$iv = $this$moveForward$iv$iv;
            boolean $i$f$loop = false;
            while (true) {
                Segment cur$iv$iv = (Segment)$this$loop$iv$iv$iv.head;
                boolean bl5 = false;
                if (cur$iv$iv.getId() >= ((Segment)to$iv$iv).getId()) {
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).tryIncPointers$kotlinx_coroutines_core()) {
                    bl = false;
                    continue block0;
                }
                if (head$FU.compareAndSet($this$moveForward$iv$iv, cur$iv$iv, to$iv$iv)) {
                    if (cur$iv$iv.decPointers$kotlinx_coroutines_core()) {
                        cur$iv$iv.remove();
                    }
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).decPointers$kotlinx_coroutines_core()) continue;
                ((ConcurrentLinkedListNode)to$iv$iv).remove();
            }
        } while (!bl);
        SemaphoreSegment segment = (SemaphoreSegment)SegmentOrClosed.getSegment-impl(s$iv);
        segment.cleanPrev();
        if (segment.getId() > id) {
            return false;
        }
        int i2 = (int)(deqIdx % (long)SemaphoreKt.access$getSEGMENT_SIZE$p());
        $this$moveForward$iv$iv = segment;
        Symbol value$iv222 = SemaphoreKt.access$getPERMIT$p();
        boolean $i$f$getAndSet = false;
        Symbol cellState = this_$iv222.acquirers.getAndSet(i2, value$iv222);
        if (cellState == null) {
            void expected$iv;
            int this_$iv222 = SemaphoreKt.access$getMAX_SPIN_CYCLES$p();
            int value$iv222 = 0;
            while (value$iv222 < this_$iv222) {
                int it = value$iv222++;
                boolean bl6 = false;
                SemaphoreSegment this_$iv = segment;
                boolean $i$f$get = false;
                if (this_$iv.acquirers.get(i2) != SemaphoreKt.access$getTAKEN$p()) continue;
                return true;
            }
            SemaphoreSegment this_$iv222 = segment;
            Symbol value$iv222 = SemaphoreKt.access$getPERMIT$p();
            Symbol value$iv = SemaphoreKt.access$getBROKEN$p();
            boolean $i$f$cas = false;
            return !this_$iv222.acquirers.compareAndSet(i2, expected$iv, value$iv);
        }
        if (cellState == SemaphoreKt.access$getCANCELLED$p()) {
            return false;
        }
        return this.tryResumeAcquire((CancellableContinuation)((Object)cellState));
    }

    private final boolean tryResumeAcquire(CancellableContinuation<? super Unit> $this$tryResumeAcquire) {
        Object object = $this$tryResumeAcquire.tryResume(Unit.INSTANCE, null, this.onCancellationRelease);
        if (object == null) {
            return false;
        }
        Object token = object;
        $this$tryResumeAcquire.completeResume(token);
        return true;
    }

    public static final /* synthetic */ Object access$acquireSlowPath(SemaphoreImpl $this, Continuation $completion) {
        return $this.acquireSlowPath($completion);
    }

    static {
        head$FU = AtomicReferenceFieldUpdater.newUpdater(SemaphoreImpl.class, Object.class, "head");
        deqIdx$FU = AtomicLongFieldUpdater.newUpdater(SemaphoreImpl.class, "deqIdx");
        tail$FU = AtomicReferenceFieldUpdater.newUpdater(SemaphoreImpl.class, Object.class, "tail");
        enqIdx$FU = AtomicLongFieldUpdater.newUpdater(SemaphoreImpl.class, "enqIdx");
        _availablePermits$FU = AtomicIntegerFieldUpdater.newUpdater(SemaphoreImpl.class, "_availablePermits");
    }
}

