/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.connection.ConnectionPoolSettings;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

class ConnectionPoolSettingsParser {
    private final ConnectionPoolSettings settings;

    public ConnectionPoolSettingsParser(ConnectionString connectionString, JsonObject config2) {
        Long maintenanceFrequencyMS;
        Long maintenanceInitialDelayMS;
        Long waitQueueTimeoutMS;
        Long maxLifeTimeMS;
        Long maxIdleTimeMS;
        Integer minPoolSize;
        Integer maxPoolSize;
        ConnectionPoolSettings.Builder settings = ConnectionPoolSettings.builder();
        if (connectionString != null) {
            settings.applyConnectionString(connectionString);
        }
        if ((maxPoolSize = config2.getInteger("maxPoolSize")) != null) {
            settings.maxSize(maxPoolSize);
        }
        if ((minPoolSize = config2.getInteger("minPoolSize")) != null) {
            settings.minSize(minPoolSize);
        }
        if ((maxIdleTimeMS = config2.getLong("maxIdleTimeMS")) != null) {
            settings.maxConnectionIdleTime(maxIdleTimeMS, TimeUnit.MILLISECONDS);
        }
        if ((maxLifeTimeMS = config2.getLong("maxLifeTimeMS")) != null) {
            settings.maxConnectionLifeTime(maxLifeTimeMS, TimeUnit.MILLISECONDS);
        }
        if ((waitQueueTimeoutMS = config2.getLong("waitQueueTimeoutMS")) != null) {
            settings.maxWaitTime(waitQueueTimeoutMS, TimeUnit.MILLISECONDS);
        }
        if ((maintenanceInitialDelayMS = config2.getLong("maintenanceInitialDelayMS")) != null) {
            settings.maintenanceInitialDelay(maintenanceInitialDelayMS, TimeUnit.MILLISECONDS);
        }
        if ((maintenanceFrequencyMS = config2.getLong("maintenanceFrequencyMS")) != null) {
            settings.maintenanceFrequency(maintenanceFrequencyMS, TimeUnit.MILLISECONDS);
        }
        this.settings = settings.build();
    }

    public ConnectionPoolSettings settings() {
        return this.settings;
    }
}

