/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import io.vertx.core.Promise;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MappingAndBufferingSubscriber<T, R>
implements Subscriber<T> {
    private final List<R> received = new ArrayList<R>();
    private final Function<T, R> converter;
    private final Promise<List<R>> promise;

    public MappingAndBufferingSubscriber(Function<T, R> converter, Promise<List<R>> promise) {
        Objects.requireNonNull(converter, "converter is null");
        Objects.requireNonNull(promise, "promise is null");
        this.promise = promise;
        this.converter = converter;
    }

    @Override
    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t) {
        this.received.add(this.converter.apply(t));
    }

    @Override
    public void onError(Throwable t) {
        this.promise.fail(t);
    }

    @Override
    public void onComplete() {
        this.promise.complete(this.received);
    }
}

