/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.BulkOperationType;
import io.vertx.ext.mongo.CollationOptions;
import java.util.Objects;

@DataObject
public class BulkOperation {
    private static final boolean DEFAULT_MULTI = false;
    private static final boolean DEFAULT_UPSERT = false;
    private BulkOperationType type;
    private JsonObject filter;
    private JsonObject document;
    private boolean upsert;
    private boolean multi;
    private JsonObject hint;
    private String hintString;
    private CollationOptions collation;

    private BulkOperation(BulkOperationType type) {
        this.type = type;
        this.filter = null;
        this.document = null;
        this.upsert = false;
        this.multi = false;
        this.hint = null;
        this.hintString = null;
        this.collation = null;
    }

    public BulkOperation(JsonObject json) {
        String typeValue = json.getString("type");
        this.type = typeValue != null ? BulkOperationType.valueOf(typeValue.toUpperCase()) : null;
        this.filter = json.getJsonObject("filter");
        this.document = json.getJsonObject("document");
        this.upsert = json.getBoolean("upsert", false);
        this.multi = json.getBoolean("multi", false);
        this.hint = json.getJsonObject("hint");
        this.hintString = json.getString("hintString");
        this.collation = json.getJsonObject("collation") != null ? new CollationOptions(json.getJsonObject("collation")) : null;
    }

    public static BulkOperation createDelete(JsonObject filter2) {
        return new BulkOperation(BulkOperationType.DELETE).setFilter(filter2);
    }

    public static BulkOperation createInsert(JsonObject document) {
        return new BulkOperation(BulkOperationType.INSERT).setDocument(document);
    }

    public static BulkOperation createReplace(JsonObject filter2, JsonObject document) {
        return new BulkOperation(BulkOperationType.REPLACE).setFilter(filter2).setDocument(document);
    }

    public static BulkOperation createReplace(JsonObject filter2, JsonObject document, boolean upsert) {
        return new BulkOperation(BulkOperationType.REPLACE).setFilter(filter2).setDocument(document).setUpsert(upsert);
    }

    public static BulkOperation createUpdate(JsonObject filter2, JsonObject document) {
        return new BulkOperation(BulkOperationType.UPDATE).setFilter(filter2).setDocument(document);
    }

    public static BulkOperation createUpdate(JsonObject filter2, JsonObject document, boolean upsert, boolean multi) {
        return new BulkOperation(BulkOperationType.UPDATE).setFilter(filter2).setDocument(document).setUpsert(upsert).setMulti(multi);
    }

    public CollationOptions getCollation() {
        return this.collation;
    }

    public BulkOperation setCollation(CollationOptions collation) {
        this.collation = collation;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("type", (Object)this.type);
        json.put("filter", this.filter);
        json.put("document", this.document);
        json.put("upsert", this.upsert);
        json.put("multi", this.multi);
        json.put("hint", this.hint);
        json.put("hintString", this.hintString);
        json.put("collation", this.collation != null ? this.collation.toJson() : null);
        return json;
    }

    public BulkOperationType getType() {
        return this.type;
    }

    public BulkOperation setType(BulkOperationType type) {
        this.type = type;
        return this;
    }

    public JsonObject getFilter() {
        return this.filter;
    }

    public BulkOperation setFilter(JsonObject filter2) {
        this.filter = filter2;
        return this;
    }

    public JsonObject getDocument() {
        return this.document;
    }

    public BulkOperation setDocument(JsonObject document) {
        this.document = document;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public BulkOperation setUpsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public BulkOperation setMulti(boolean multi) {
        this.multi = multi;
        return this;
    }

    public JsonObject getHint() {
        return this.hint;
    }

    public BulkOperation setHint(JsonObject hint) {
        this.hint = hint;
        return this;
    }

    public String getHintString() {
        return this.hintString;
    }

    public BulkOperation setHintString(String hintString) {
        this.hintString = hintString;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkOperation operation = (BulkOperation)o;
        return this.upsert == operation.upsert && this.multi == operation.multi && this.type == operation.type && Objects.equals(this.filter, operation.filter) && Objects.equals(this.document, operation.document) && Objects.equals(this.hint, operation.hint) && Objects.equals(this.hintString, operation.hintString) && Objects.equals(this.collation, operation.collation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.filter, this.document, this.upsert, this.multi, this.hint, this.hintString, this.collation});
    }

    public String toString() {
        return "BulkOperation{type=" + (Object)((Object)this.type) + ", filter=" + this.filter + ", document=" + this.document + ", upsert=" + this.upsert + ", multi=" + this.multi + ", hint=" + this.hint + ", hintString='" + this.hintString + '\'' + ", collation=" + this.collation + '}';
    }
}

