/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class Codec {
    private static final byte[] BASE16 = "0123456789abcdef".getBytes(StandardCharsets.US_ASCII);
    private static final int[] BASE16_LOOKUP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 255, 255, 255, 255, 255, 255, 255, 10, 11, 12, 13, 14, 15, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 10, 11, 12, 13, 14, 15, 255};
    private static final char[] BASE32 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();
    private static final int[] BASE32_LOOKUP = new int[]{255, 255, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255};
    private static final Base64.Encoder BASE64URL = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder BASE64URL_DECODER = Base64.getUrlDecoder();
    private static final Base64.Encoder BASE64 = Base64.getEncoder();
    private static final Base64.Encoder BASE64_NOPADDING = Base64.getEncoder().withoutPadding();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder BASE64MIME = Base64.getMimeEncoder();
    private static final Base64.Decoder BASE64MIME_DECODER = Base64.getMimeDecoder();

    private Codec() {
    }

    public static String base16Encode(byte[] bytes) {
        byte[] base16 = new byte[bytes.length * 2];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            int v = bytes[i2] & 0xFF;
            base16[i2 * 2] = BASE16[v >>> 4];
            base16[i2 * 2 + 1] = BASE16[v & 0xF];
        }
        return new String(base16, StandardCharsets.ISO_8859_1);
    }

    public static byte[] base16Decode(String base16) {
        byte[] bytes = new byte[base16.length() / 2];
        for (int i2 = 0; i2 < base16.length(); i2 += 2) {
            int lookup = base16.charAt(i2) - 48;
            if (lookup < 0 || lookup >= BASE16_LOOKUP.length) {
                throw new IllegalArgumentException("Invalid char: " + base16.charAt(i2));
            }
            int high = BASE16_LOOKUP[lookup];
            if (high == 255) {
                throw new IllegalArgumentException("Invalid char: " + base16.charAt(i2));
            }
            lookup = base16.charAt(i2 + 1) - 48;
            if (lookup < 0 || lookup >= BASE16_LOOKUP.length) {
                throw new IllegalArgumentException("Invalid char: " + base16.charAt(i2 + 1));
            }
            int low = BASE16_LOOKUP[lookup];
            if (low == 255) {
                throw new IllegalArgumentException("Invalid char: " + base16.charAt(i2 + 1));
            }
            bytes[i2 / 2] = (byte)((high << 4) + low);
        }
        return bytes;
    }

    public static String base32Encode(byte[] bytes) {
        int i2 = 0;
        int index = 0;
        StringBuilder base32 = new StringBuilder((bytes.length + 7) * 8 / 5);
        while (i2 < bytes.length) {
            int digit;
            int currByte;
            int n = currByte = bytes[i2] >= 0 ? bytes[i2] : bytes[i2] + 256;
            if (index > 3) {
                int nextByte = i2 + 1 < bytes.length ? (bytes[i2 + 1] >= 0 ? bytes[i2 + 1] : bytes[i2 + 1] + 256) : 0;
                digit = currByte & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= nextByte >> 8 - index;
                ++i2;
            } else {
                digit = currByte >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i2;
                }
            }
            base32.append(BASE32[digit]);
        }
        return base32.toString();
    }

    public static byte[] base32Decode(String base32) {
        byte[] bytes = new byte[base32.length() * 5 / 8];
        int index = 0;
        int offset = 0;
        for (int i2 = 0; i2 < base32.length(); ++i2) {
            int lookup = base32.charAt(i2) - 48;
            if (lookup < 0 || lookup >= BASE32_LOOKUP.length) {
                throw new IllegalArgumentException("Invalid char: " + base32.charAt(i2));
            }
            int digit = BASE32_LOOKUP[lookup];
            if (digit == 255) {
                throw new IllegalArgumentException("Invalid char: " + base32.charAt(i2));
            }
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n = offset++;
                    bytes[n] = (byte)(bytes[n] | digit);
                    if (offset < bytes.length) continue;
                    break;
                }
                int n = offset;
                bytes[n] = (byte)(bytes[n] | digit << 8 - index);
                continue;
            }
            index = (index + 5) % 8;
            int n = offset++;
            bytes[n] = (byte)(bytes[n] | digit >>> index);
            if (offset >= bytes.length) break;
            int n2 = offset;
            bytes[n2] = (byte)(bytes[n2] | digit << 8 - index);
        }
        return bytes;
    }

    public static String base64UrlEncode(byte[] bytes) {
        return BASE64URL.encodeToString(bytes);
    }

    public static byte[] base64UrlDecode(String base64) {
        return BASE64URL_DECODER.decode(base64);
    }

    public static byte[] base64UrlDecode(byte[] base64) {
        return BASE64URL_DECODER.decode(base64);
    }

    public static String base64Encode(byte[] bytes) {
        return BASE64.encodeToString(bytes);
    }

    public static String base64EncodeWithoutPadding(byte[] bytes) {
        return BASE64_NOPADDING.encodeToString(bytes);
    }

    public static byte[] base64Decode(String base64) {
        return BASE64_DECODER.decode(base64);
    }

    public static byte[] base64Decode(byte[] base64) {
        return BASE64_DECODER.decode(base64);
    }

    public static String base64MimeEncode(byte[] bytes) {
        return BASE64MIME.encodeToString(bytes);
    }

    public static byte[] base64MimeDecode(String base64) {
        return BASE64MIME_DECODER.decode(base64);
    }

    public static byte[] base64MimeDecode(byte[] base64) {
        return BASE64MIME_DECODER.decode(base64);
    }
}

