/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.util;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/sip3/salto/ce/util/DurationUtil;", "", "()V", "parseDuration", "Ljava/time/Duration;", "duration", "", "sip3-salto-ce"})
public final class DurationUtil {
    @NotNull
    public static final DurationUtil INSTANCE = new DurationUtil();

    private DurationUtil() {
    }

    @NotNull
    public final Duration parseDuration(@NotNull String duration) {
        Duration duration2;
        Intrinsics.checkNotNullParameter(duration, "duration");
        if (StringsKt.endsWith$default(duration, "ms", false, 2, null)) {
            Duration duration3 = Duration.ofMillis(Long.parseLong(StringsKt.substringBefore$default(duration, "ms", null, 2, null)));
            duration2 = duration3;
            Intrinsics.checkNotNullExpressionValue(duration3, "ofMillis(duration.substringBefore(\"ms\").toLong())");
        } else if (StringsKt.endsWith$default(duration, "s", false, 2, null)) {
            Duration duration4 = Duration.ofSeconds(Long.parseLong(StringsKt.substringBefore$default(duration, "s", null, 2, null)));
            duration2 = duration4;
            Intrinsics.checkNotNullExpressionValue(duration4, "ofSeconds(duration.substringBefore(\"s\").toLong())");
        } else if (StringsKt.endsWith$default(duration, "m", false, 2, null)) {
            Duration duration5 = Duration.ofMinutes(Long.parseLong(StringsKt.substringBefore$default(duration, "m", null, 2, null)));
            duration2 = duration5;
            Intrinsics.checkNotNullExpressionValue(duration5, "ofMinutes(duration.substringBefore(\"m\").toLong())");
        } else if (StringsKt.endsWith$default(duration, "h", false, 2, null)) {
            Duration duration6 = Duration.ofHours(Long.parseLong(StringsKt.substringBefore$default(duration, "h", null, 2, null)));
            duration2 = duration6;
            Intrinsics.checkNotNullExpressionValue(duration6, "ofHours(duration.substringBefore(\"h\").toLong())");
        } else {
            throw new IllegalArgumentException("Unsupported time format: " + duration);
        }
        return duration2;
    }
}

