/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.sip;

import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.attributes.AttributesRegistry;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.sip.SipRegisterHandler;
import io.sip3.salto.ce.sip.SipTransaction;
import io.sip3.salto.ce.util.AttributeUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Counter;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0017\u0018\u0000 02\u00020\u0001:\u0003012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0014\u0010\u001f\u001a\u00020\u001c2\n\u0010 \u001a\u00060\u0006R\u00020\u0000H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\f2\n\u0010&\u001a\u00060\nR\u00020\u0000H\u0002J\b\u0010'\u001a\u00020\u001cH\u0016J\u001c\u0010(\u001a\u00020\u001c2\n\u0010&\u001a\u00060\nR\u00020\u00002\u0006\u0010)\u001a\u00020\u0016H\u0002J\u0014\u0010*\u001a\u00020\u001c2\n\u0010 \u001a\u00060\u0006R\u00020\u0000H\u0016J\u0014\u0010+\u001a\u00020\u001c2\n\u0010&\u001a\u00060\nR\u00020\u0000H\u0002J\u0014\u0010,\u001a\u00020\f2\n\u0010&\u001a\u00060\nR\u00020\u0000H\u0016J\u0014\u0010-\u001a\u00020\u001c2\n\u0010 \u001a\u00060\u0006R\u00020\u0000H\u0016J&\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u00052\n\u0010 \u001a\u00060\u0006R\u00020\u00002\b\b\u0002\u0010)\u001a\u00020\u0016H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00000\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\nR\u00020\u00000\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/sip3/salto/ce/sip/SipRegisterHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "activeRegistrations", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "", "Lio/sip3/salto/ce/sip/SipRegisterHandler$SipRegistration;", "activeSessionCounters", "Ljava/util/concurrent/atomic/AtomicInteger;", "activeSessions", "Lio/sip3/salto/ce/sip/SipRegisterHandler$SipSession;", "aggregationTimeout", "", "attributesRegistry", "Lio/sip3/salto/ce/attributes/AttributesRegistry;", "durationTimeout", "expirationDelay", "hint", "Lio/vertx/core/json/JsonObject;", "logger", "Lmu/KLogger;", "recordCallUsersAttributes", "", "recordIpAddressesAttributes", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "updatePeriod", "calculateActiveSessions", "", "hostsKey", "counter", "calculateRegistrationMetrics", "registration", "handle", "transaction", "Lio/sip3/salto/ce/sip/SipTransaction;", "onRemain", "now", "session", "start", "syncSession", "upsert", "terminateRegistration", "terminateSession", "terminateSessionAt", "writeAttributes", "writeToDatabase", "prefix", "Companion", "SipRegistration", "SipSession", "sip3-salto-ce"})
public class SipRegisterHandler
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private DateTimeFormatter timeSuffix;
    private long expirationDelay;
    private long aggregationTimeout;
    private long updatePeriod;
    private long durationTimeout;
    private boolean recordIpAddressesAttributes;
    private boolean recordCallUsersAttributes;
    @Nullable
    private JsonObject hint;
    private PeriodicallyExpiringHashMap<String, SipRegistration> activeRegistrations;
    private PeriodicallyExpiringHashMap<String, SipSession> activeSessions;
    private PeriodicallyExpiringHashMap<String, AtomicInteger> activeSessionCounters;
    private AttributesRegistry attributesRegistry;
    @NotNull
    private static final List<String> EXCLUDED_ATTRIBUTES;
    @NotNull
    public static final String PREFIX = "sip_register";
    @NotNull
    public static final String UNKNOWN = "unknown";
    @NotNull
    public static final String REDIRECTED = "redirected";
    @NotNull
    public static final String FAILED = "failed";
    @NotNull
    public static final String REGISTERED = "registered";
    @NotNull
    public static final String UNAUTHORIZED = "unauthorized";
    @NotNull
    public static final String REQUEST_DELAY = "sip_register_request-delay";
    @NotNull
    public static final String REMOVED = "sip_register_removed";
    @NotNull
    public static final String ACTIVE = "sip_register_active";
    @NotNull
    public static final String OVERLAPPED_INTERVAL = "sip_register_overlapped-interval";
    @NotNull
    public static final String OVERLAPPED_FRACTION = "sip_register_overlapped-fraction";

    public SipRegisterHandler() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.expirationDelay = 1000L;
        this.aggregationTimeout = 10000L;
        this.updatePeriod = 60000L;
        this.durationTimeout = 900000L;
    }

    @Override
    public void start() {
        JsonObject jsonObject;
        String string = this.config().getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(it)");
            this.timeSuffix = dateTimeFormatter;
        }
        if ((jsonObject = this.config().getJsonObject("sip")) != null && (jsonObject = jsonObject.getJsonObject("register")) != null) {
            long it;
            Long l;
            JsonObject config2 = jsonObject;
            boolean bl = false;
            Long l2 = l = config2.getLong("expiration_delay");
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue(l2, "getLong(\"expiration_delay\")");
                it = ((Number)l).longValue();
                boolean bl2 = false;
                this.expirationDelay = it;
            }
            Long l3 = l = config2.getLong("aggregation_timeout");
            if (l3 != null) {
                Intrinsics.checkNotNullExpressionValue(l3, "getLong(\"aggregation_timeout\")");
                it = ((Number)l).longValue();
                boolean bl3 = false;
                this.aggregationTimeout = it;
            }
            Long l4 = l = config2.getLong("update_period");
            if (l4 != null) {
                Intrinsics.checkNotNullExpressionValue(l4, "getLong(\"update_period\")");
                it = ((Number)l).longValue();
                boolean bl4 = false;
                this.updatePeriod = it;
            }
            Long l5 = l = config2.getLong("duration_timeout");
            if (l5 != null) {
                Intrinsics.checkNotNullExpressionValue(l5, "getLong(\"duration_timeout\")");
                it = ((Number)l).longValue();
                boolean bl5 = false;
                this.durationTimeout = it;
            }
        }
        JsonObject jsonObject2 = this.config().getJsonObject("attributes");
        if (jsonObject2 != null) {
            Boolean bl;
            JsonObject config3 = jsonObject2;
            boolean bl6 = false;
            Boolean bl7 = bl = config3.getBoolean("record_ip_addresses");
            if (bl7 != null) {
                Intrinsics.checkNotNullExpressionValue(bl7, "getBoolean(\"record_ip_addresses\")");
                boolean it = bl;
                boolean bl8 = false;
                this.recordIpAddressesAttributes = it;
            }
            Boolean bl9 = bl = config3.getBoolean("record_call_users");
            if (bl9 != null) {
                Intrinsics.checkNotNullExpressionValue(bl9, "getBoolean(\"record_call_users\")");
                boolean it = bl;
                boolean bl10 = false;
                this.recordCallUsersAttributes = it;
            }
        }
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        JsonObject jsonObject3 = this.config();
        Intrinsics.checkNotNullExpressionValue(jsonObject3, "config()");
        this.attributesRegistry = new AttributesRegistry(vertx, jsonObject3);
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, SipRegistration, Long>(this){
            final /* synthetic */ SipRegisterHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull SipRegistration registration) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(registration, "registration");
                return registration.getCreatedAt() + SipRegisterHandler.access$getAggregationTimeout$p(this.this$0);
            }
        }).onExpire((Function2)new Function2<String, SipRegistration, Unit>(this){
            final /* synthetic */ SipRegisterHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull SipRegistration registration) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(registration, "registration");
                this.this$0.terminateRegistration(registration);
            }
        });
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx2, "vertx");
        this.activeRegistrations = builder.build(vertx2);
        PeriodicallyExpiringHashMap.Builder builder2 = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, SipSession, Long>(this){
            final /* synthetic */ SipRegisterHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull SipSession session2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(session2, "session");
                return this.this$0.terminateSessionAt(session2);
            }
        }).onRemain((Function3)new Function3<Long, String, SipSession, Unit>(this){
            final /* synthetic */ SipRegisterHandler this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(long now, @NotNull String string, @NotNull SipSession session2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 1>");
                Intrinsics.checkNotNullParameter(session2, "session");
                SipRegisterHandler.access$onRemain(this.this$0, now, session2);
            }
        }).onExpire((Function2)new Function2<String, SipSession, Unit>(this){
            final /* synthetic */ SipRegisterHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull SipSession session2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(session2, "session");
                SipRegisterHandler.access$terminateSession(this.this$0, session2);
            }
        });
        Vertx vertx3 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx3, "vertx");
        this.activeSessions = builder2.build(vertx3);
        PeriodicallyExpiringHashMap.Builder builder3 = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).expireAt(start.9.INSTANCE).onRemain((Function2)new Function2<String, AtomicInteger, Unit>(this){
            final /* synthetic */ SipRegisterHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String hostsKey, @NotNull AtomicInteger counter) {
                Intrinsics.checkNotNullParameter(hostsKey, "hostsKey");
                Intrinsics.checkNotNullParameter(counter, "counter");
                this.this$0.calculateActiveSessions(hostsKey, counter);
            }
        });
        Vertx vertx4 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx4, "vertx");
        this.activeSessionCounters = builder3.build(vertx4);
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localRequest$default(eventBus, RoutesCE.Companion.getMongo_collection_hint(), "sip_register_index", null, new Function1<AsyncResult<Message<JsonObject>>, Unit>(this){
            final /* synthetic */ SipRegisterHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AsyncResult<Message<JsonObject>> asr) {
                Intrinsics.checkNotNullParameter(asr, "asr");
                if (asr.succeeded()) {
                    JsonObject jsonObject = asr.result().body();
                    if (jsonObject != null) {
                        JsonObject jsonObject2 = jsonObject;
                        SipRegisterHandler sipRegisterHandler = this.this$0;
                        JsonObject it = jsonObject2;
                        boolean bl = false;
                        SipRegisterHandler.access$setHint$p(sipRegisterHandler, it);
                    }
                } else {
                    SipRegisterHandler.access$getLogger$p(this.this$0).error(asr.cause(), (Function0<? extends Object>)start.2.INSTANCE);
                }
            }
        }, 4, null);
        CoroutineScope coroutineScope = GlobalScope.INSTANCE;
        Vertx vertx5 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx5, "vertx");
        CoroutineDispatcher coroutineDispatcher = VertxCoroutineKt.dispatcher(vertx5);
        Intrinsics.checkNotNull(coroutineDispatcher, "null cannot be cast to non-null type kotlin.coroutines.CoroutineContext");
        BuildersKt.launch$default(coroutineScope, coroutineDispatcher, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ SipRegisterHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        v0 = SipRegisterHandler.access$getVertx$p$s1710471949(this.this$0).sharedData().getLocalCounter("sip_register");
                        Intrinsics.checkNotNullExpressionValue(v0, "vertx.sharedData().getLocalCounter(PREFIX)");
                        this.label = 1;
                        v1 = VertxCoroutineKt.coAwait(v0, this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        index = (Counter)v1;
                        var4_4 = SipRegisterHandler.access$getVertx$p$s1710471949(this.this$0).eventBus();
                        var3_5 = index.getAndIncrement();
                        Intrinsics.checkNotNullExpressionValue(var3_5, "index.andIncrement");
                        this.L$0 = var4_4;
                        this.label = 2;
                        v2 = VertxCoroutineKt.coAwait(var3_5, this);
                        if (v2 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        var4_4 = (EventBus)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        var4_4.localConsumer("sip_register_" + v2, (Handler<Message<T>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$0(io.sip3.salto.ce.sip.SipRegisterHandler io.vertx.core.eventbus.Message ), (Lio/vertx/core/eventbus/Message;)V)((SipRegisterHandler)this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(SipRegisterHandler this$0, Message event) {
                try {
                    SipTransaction transaction2 = (SipTransaction)event.body();
                    Intrinsics.checkNotNullExpressionValue(transaction2, "transaction");
                    this$0.handle(transaction2);
                }
                catch (Exception e) {
                    SipRegisterHandler.access$getLogger$p(this$0).error("SipRegisterHandler 'handle()' failed.", e);
                }
            }
        }, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    public void handle(@NotNull SipTransaction transaction) {
        block18: {
            Intrinsics.checkNotNullParameter(transaction, "transaction");
            id = transaction.getLegId() + ":" + transaction.getCallId();
            v0 = this.activeRegistrations;
            if (v0 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeRegistrations");
                v0 = null;
            }
            if ((v1 = v0.get(id)) == null) {
                v1 = new SipRegistration();
            }
            registration = v1;
            registration.addRegisterTransaction(transaction);
            var4_4 = registration.getState();
            switch (var4_4.hashCode()) {
                case 1449033083: {
                    if (!var4_4.equals("redirected")) {
                        ** break;
                    }
                    ** GOTO lbl26
                }
                case -1869930878: {
                    if (var4_4.equals("registered")) break;
                    ** break;
                }
                case -1281977283: {
                    if (!var4_4.equals("failed")) {
                        ** break;
                    }
                    ** GOTO lbl26
                }
                case -284840886: {
                    if (!var4_4.equals("unknown")) ** break;
lbl26:
                    // 3 sources

                    this.terminateRegistration(registration);
                    v2 = this.activeRegistrations;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("activeRegistrations");
                        v2 = null;
                    }
                    v2.remove(id);
                    break block18;
                }
            }
            this.calculateRegistrationMetrics(registration);
            v3 = this.activeSessions;
            if (v3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeSessions");
                v3 = null;
            }
            session = v3.getOrPut(id, new Function0<SipSession>(transaction, this){
                final /* synthetic */ SipTransaction $transaction;
                final /* synthetic */ SipRegisterHandler this$0;
                {
                    this.$transaction = $transaction;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final SipSession invoke() {
                    String string;
                    String string2 = this.$transaction.getSrcAddr().getHost();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string = this.$transaction.getDstAddr().getHost()) == null) {
                        string = "";
                    }
                    String activeSessionCountersKey = string2 + ":" + string;
                    PeriodicallyExpiringHashMap periodicallyExpiringHashMap = SipRegisterHandler.access$getActiveSessionCounters$p(this.this$0);
                    if (periodicallyExpiringHashMap == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("activeSessionCounters");
                        periodicallyExpiringHashMap = null;
                    }
                    ((AtomicInteger)periodicallyExpiringHashMap.getOrPut(activeSessionCountersKey, handle.session.1.INSTANCE)).incrementAndGet();
                    return this.this$0.new SipSession();
                }
            });
            session.addSipRegistration(registration);
            v4 = this.activeRegistrations;
            if (v4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeRegistrations");
                v4 = null;
            }
            v4.remove(id);
            v5 = session.getOverlappedInterval();
            if (v5 != null) {
                interval = ((Number)v5).longValue();
                $i$a$-let-SipRegisterHandler$handle$1 = false;
                $this$handle_u24lambda_u2413_u24lambda_u2411 = var9_8 = AttributeUtilKt.toMetricsAttributes(registration.getAttributes(), SipRegisterHandler.EXCLUDED_ATTRIBUTES);
                $i$a$-apply-SipRegisterHandler$handle$1$attributes$1 = false;
                v6 = registration.getSrcAddr().getHost();
                if (v6 != null) {
                    it = v6;
                    $i$a$-let-SipRegisterHandler$handle$1$attributes$1$1 = false;
                    $this$handle_u24lambda_u2413_u24lambda_u2411.put("src_host", it);
                }
                v7 = registration.getDstAddr().getHost();
                if (v7 != null) {
                    it = v7;
                    $i$a$-let-SipRegisterHandler$handle$1$attributes$1$2 = false;
                    $this$handle_u24lambda_u2413_u24lambda_u2411.put("dst_host", it);
                }
                attributes = var9_8;
                Metrics.INSTANCE.timer("sip_register_overlapped-interval", attributes).record(interval, TimeUnit.MILLISECONDS);
                v8 = session.getOverlappedFraction();
                if (v8 != null) {
                    it = ((Number)v8).doubleValue();
                    $i$a$-let-SipRegisterHandler$handle$1$1 = false;
                    Metrics.INSTANCE.summary("sip_register_overlapped-fraction", attributes).record(it);
                }
            }
            break block18;
lbl75:
            // 5 sources

            if ((v9 = this.activeRegistrations) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeRegistrations");
                v9 = null;
            }
            v9.put(id, registration);
        }
    }

    public void calculateRegistrationMetrics(@NotNull SipRegistration registration) {
        block5: {
            String it;
            Map<String, Object> map2;
            Intrinsics.checkNotNullParameter(registration, "registration");
            long createdAt = registration.getCreatedAt();
            Map<String, Object> $this$calculateRegistrationMetrics_u24lambda_u2416 = map2 = AttributeUtilKt.toMetricsAttributes(registration.getAttributes(), EXCLUDED_ATTRIBUTES);
            boolean bl = false;
            String string = registration.getSrcAddr().getHost();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                $this$calculateRegistrationMetrics_u24lambda_u2416.put("src_host", it);
            }
            String string2 = registration.getDstAddr().getHost();
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                $this$calculateRegistrationMetrics_u24lambda_u2416.put("dst_host", it);
            }
            Map<String, Object> attributes = map2;
            Long l = registration.getTerminatedAt();
            if (l == null) break block5;
            long terminatedAt = ((Number)l).longValue();
            boolean bl4 = false;
            if (createdAt < terminatedAt) {
                Metrics.INSTANCE.timer(REQUEST_DELAY, attributes).record(terminatedAt - createdAt, TimeUnit.MILLISECONDS);
            }
            Long l2 = registration.getExpiresAt();
            if (l2 != null) {
                long expiresAt = ((Number)l2).longValue();
                boolean bl5 = false;
                if (expiresAt == terminatedAt) {
                    Metrics.INSTANCE.counter(REMOVED, attributes).increment();
                }
            }
        }
    }

    public void terminateRegistration(@NotNull SipRegistration registration) {
        Intrinsics.checkNotNullParameter(registration, "registration");
        if (registration.getTerminatedAt() == null) {
            registration.setTerminatedAt(System.currentTimeMillis());
        }
        this.writeAttributes(registration);
        this.writeToDatabase(PREFIX, registration, false);
    }

    public long terminateSessionAt(@NotNull SipSession session2) {
        long l;
        Intrinsics.checkNotNullParameter(session2, "session");
        Long l2 = session2.getExpiresAt();
        if (l2 != null) {
            l = l2;
        } else {
            Long l3 = session2.getTerminatedAt();
            l = l3 != null ? l3.longValue() : session2.getCreatedAt();
        }
        return l + this.aggregationTimeout;
    }

    private final void onRemain(long now, SipSession session2) {
        block6: {
            block7: {
                if (session2.getSynced()) break block6;
                if (session2.getUpdatedAt() == null) break block7;
                Long l = session2.getUpdatedAt();
                Intrinsics.checkNotNull(l);
                if (l + this.updatePeriod >= now) break block6;
            }
            if (session2.getCreatedAt() + this.durationTimeout < now) {
                Pair<Long, Long> lastRegistration = CollectionsKt.removeLast(session2.getRegistrations());
                Long l = session2.getTerminatedAt();
                if (l == null) {
                    l = session2.getExpiresAt();
                }
                Intrinsics.checkNotNull(l);
                session2.setDuration(l - session2.getCreatedAt());
                this.syncSession(session2, true);
                session2.reset(lastRegistration);
            } else {
                this.syncSession(session2, session2.getUpdatedAt() != null);
                session2.setUpdatedAt(now);
            }
        }
    }

    private final void syncSession(SipSession session2, boolean upsert) {
        this.writeAttributes(session2);
        this.writeToDatabase(PREFIX, session2, upsert);
        session2.getRegistrations().clear();
        session2.setSynced(true);
    }

    private final void terminateSession(SipSession session2) {
        block4: {
            String string;
            if (session2.getTerminatedAt() == null) {
                session2.setTerminatedAt(System.currentTimeMillis());
            }
            Long l = session2.getTerminatedAt();
            Intrinsics.checkNotNull(l);
            session2.setDuration(l - session2.getCreatedAt());
            this.writeAttributes(session2);
            this.writeToDatabase(PREFIX, session2, true);
            String string2 = session2.getSrcAddr().getHost();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = session2.getDstAddr().getHost()) == null) {
                string = "";
            }
            String activeSessionCountersKey = string2 + ":" + string;
            PeriodicallyExpiringHashMap<String, AtomicInteger> periodicallyExpiringHashMap = this.activeSessionCounters;
            if (periodicallyExpiringHashMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeSessionCounters");
                periodicallyExpiringHashMap = null;
            }
            AtomicInteger atomicInteger = periodicallyExpiringHashMap.get(activeSessionCountersKey);
            if (atomicInteger == null) break block4;
            atomicInteger.decrementAndGet();
        }
    }

    public void calculateActiveSessions(@NotNull String hostsKey, @NotNull AtomicInteger counter) {
        Map map2;
        Intrinsics.checkNotNullParameter(hostsKey, "hostsKey");
        Intrinsics.checkNotNullParameter(counter, "counter");
        String[] stringArray = new String[]{":"};
        List hosts = StringsKt.split$default((CharSequence)hostsKey, stringArray, false, 0, 6, null);
        Map $this$calculateActiveSessions_u24lambda_u2419 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)hosts.get(0))) {
            $this$calculateActiveSessions_u24lambda_u2419.put("src_host", hosts.get(0));
        }
        if (!StringsKt.isBlank((CharSequence)hosts.get(1))) {
            $this$calculateActiveSessions_u24lambda_u2419.put("dst_host", hosts.get(1));
        }
        Map attributes = map2;
        Metrics.INSTANCE.counter(ACTIVE, attributes).increment(counter.doubleValue());
    }

    public void writeAttributes(@NotNull SipRegistration registration) {
        String it;
        Object object;
        Map map2;
        Intrinsics.checkNotNullParameter(registration, "registration");
        Map $this$writeAttributes_u24lambda_u2427 = map2 = AttributeUtilKt.toAttributes$default(registration.getAttributes(), null, 1, null);
        boolean bl = false;
        $this$writeAttributes_u24lambda_u2427.put("method", "REGISTER");
        $this$writeAttributes_u24lambda_u2427.put("state", registration.getState());
        Address src = registration.getSrcAddr();
        $this$writeAttributes_u24lambda_u2427.put("src_addr", this.recordIpAddressesAttributes ? src.getAddr() : "");
        String string = src.getHost();
        if (string != null) {
            String it2 = string;
            boolean bl2 = false;
            $this$writeAttributes_u24lambda_u2427.put("src_host", it2);
        }
        Address dst = registration.getDstAddr();
        $this$writeAttributes_u24lambda_u2427.put("dst_addr", this.recordIpAddressesAttributes ? dst.getAddr() : "");
        String string2 = dst.getHost();
        if (string2 != null) {
            String it3 = string2;
            boolean bl3 = false;
            $this$writeAttributes_u24lambda_u2427.put("dst_host", it3);
        }
        if ((object = $this$writeAttributes_u24lambda_u2427.get("caller")) == null) {
            object = registration.getCaller();
        }
        Object caller = object;
        $this$writeAttributes_u24lambda_u2427.put("caller", this.recordCallUsersAttributes ? caller : "");
        Object object2 = $this$writeAttributes_u24lambda_u2427.get("callee");
        if (object2 == null) {
            object2 = registration.getCallee();
        }
        Object callee = object2;
        $this$writeAttributes_u24lambda_u2427.put("callee", this.recordCallUsersAttributes ? callee : "");
        $this$writeAttributes_u24lambda_u2427.put("call_id", "");
        $this$writeAttributes_u24lambda_u2427.put("transactions", registration.getTransactions());
        $this$writeAttributes_u24lambda_u2427.put("retransmits", registration.getRetransmits());
        String string3 = registration.getErrorCode();
        if (string3 != null) {
            it = string3;
            boolean bl4 = false;
            $this$writeAttributes_u24lambda_u2427.put("error_code", it);
        }
        String string4 = registration.getErrorType();
        if (string4 != null) {
            it = string4;
            boolean bl5 = false;
            $this$writeAttributes_u24lambda_u2427.put("error_type", it);
        }
        SipSession sipSession = registration instanceof SipSession ? (SipSession)registration : null;
        if (sipSession != null) {
            SipSession session2 = sipSession;
            boolean bl6 = false;
            Long l = session2.getOverlappedInterval();
            if (l != null) {
                long it4 = ((Number)l).longValue();
                boolean bl7 = false;
                $this$writeAttributes_u24lambda_u2427.put("overlapped_interval", it4);
            }
            Double d = session2.getOverlappedFraction();
            if (d != null) {
                double it5 = ((Number)d).doubleValue();
                boolean bl8 = false;
                $this$writeAttributes_u24lambda_u2427.put("overlapped_fraction", it5);
            }
        }
        $this$writeAttributes_u24lambda_u2427.remove("x_call_id");
        $this$writeAttributes_u24lambda_u2427.remove("recording_mode");
        Map attributes = map2;
        AttributesRegistry attributesRegistry = this.attributesRegistry;
        if (attributesRegistry == null) {
            Intrinsics.throwUninitializedPropertyAccessException("attributesRegistry");
            attributesRegistry = null;
        }
        attributesRegistry.handle("sip", attributes);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToDatabase(@NotNull String prefix, @NotNull SipRegistration registration, boolean upsert) {
        void $this$forEach$iv;
        Object object;
        String it;
        void $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446;
        Unit unit;
        Object dst;
        JsonObject $this$writeToDatabase_u24lambda_u2447_u24lambda_u2430;
        JsonObject jsonObject;
        String string;
        JsonObject jsonObject2;
        JsonObject $this$writeToDatabase_u24lambda_u2447;
        JsonObject jsonObject3;
        String collection;
        block26: {
            block30: {
                Object object2;
                block29: {
                    block28: {
                        Object object3;
                        Address src;
                        block27: {
                            Intrinsics.checkNotNullParameter(prefix, "prefix");
                            Intrinsics.checkNotNullParameter(registration, "registration");
                            collection = prefix + "_index_" + DateTimeFormatterUtilKt.format(this.timeSuffix, registration.getCreatedAt());
                            $this$writeToDatabase_u24lambda_u2447 = jsonObject3 = new JsonObject();
                            boolean bl = false;
                            if (!upsert) break block26;
                            $this$writeToDatabase_u24lambda_u2447.put("type", "UPDATE");
                            $this$writeToDatabase_u24lambda_u2447.put("upsert", true);
                            JsonObject jsonObject4 = jsonObject2 = new JsonObject();
                            string = "filter";
                            jsonObject = $this$writeToDatabase_u24lambda_u2447;
                            boolean bl2 = false;
                            $this$writeToDatabase_u24lambda_u2447_u24lambda_u2430.put("call_id", registration.getCallId());
                            $this$writeToDatabase_u24lambda_u2447_u24lambda_u2430.put("created_at", registration.getCreatedAt());
                            src = registration.getSrcAddr();
                            object3 = src.getHost();
                            if (object3 == null) break block27;
                            String it2 = object3;
                            boolean bl3 = false;
                            JsonObject jsonObject5 = $this$writeToDatabase_u24lambda_u2447_u24lambda_u2430.put("src_host", it2);
                            object3 = jsonObject5;
                            if (jsonObject5 != null) break block28;
                        }
                        object3 = $this$writeToDatabase_u24lambda_u2447_u24lambda_u2430.put("src_addr", src.getAddr());
                    }
                    if ((object2 = ((Address)(dst = registration.getDstAddr())).getHost()) == null) break block29;
                    String it3 = object2;
                    boolean bl = false;
                    JsonObject jsonObject6 = $this$writeToDatabase_u24lambda_u2447_u24lambda_u2430.put("dst_host", it3);
                    object2 = jsonObject6;
                    if (jsonObject6 != null) break block30;
                }
                object2 = $this$writeToDatabase_u24lambda_u2447_u24lambda_u2430.put("dst_addr", ((Address)dst).getAddr());
            }
            unit = Unit.INSTANCE;
            jsonObject.put(string, jsonObject2);
            JsonObject jsonObject7 = this.hint;
            if (jsonObject7 != null) {
                JsonObject it4 = jsonObject7;
                boolean bl = false;
                $this$writeToDatabase_u24lambda_u2447.put("hint", it4);
            }
        }
        $this$writeToDatabase_u24lambda_u2447_u24lambda_u2430 = jsonObject2 = new JsonObject();
        string = "document";
        jsonObject = $this$writeToDatabase_u24lambda_u2447;
        boolean bl = false;
        JsonObject document = null;
        document = $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446;
        Address src = registration.getSrcAddr();
        Address dst2 = registration.getDstAddr();
        if (upsert) {
            document = new JsonObject();
            $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446.put("$setOnInsert", document);
        }
        dst = document;
        JsonObject $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2432 = dst;
        boolean bl4 = false;
        $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2432.put("created_at", registration.getCreatedAt());
        $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2432.put("src_addr", src.getAddr());
        $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2432.put("src_port", src.getPort());
        $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2432.put("dst_addr", dst2.getAddr());
        $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2432.put("dst_port", dst2.getPort());
        $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2432.put("call_id", registration.getCallId());
        if (upsert) {
            document = new JsonObject();
            $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446.put("$set", document);
        }
        Object $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439 = dst = document;
        boolean bl5 = false;
        ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("state", registration.getState());
        Long l = registration.getTerminatedAt();
        if (l == null) {
            l = registration.getExpiresAt();
        }
        if (l != null) {
            long it5 = ((Number)l).longValue();
            boolean bl6 = false;
            ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("terminated_at", it5);
        }
        String string2 = registration.getSrcAddr().getHost();
        if (string2 != null) {
            it = string2;
            boolean bl7 = false;
            ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("src_host", it);
        }
        String string3 = registration.getDstAddr().getHost();
        if (string3 != null) {
            it = string3;
            boolean bl8 = false;
            ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("dst_host", it);
        }
        if ((object = registration.getAttributes().get("caller")) == null) {
            object = registration.getCaller();
        }
        ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("caller", object);
        Object object4 = registration.getAttributes().get("callee");
        if (object4 == null) {
            object4 = registration.getCallee();
        }
        ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("callee", object4);
        String string4 = registration.getErrorCode();
        if (string4 != null) {
            it = string4;
            boolean bl9 = false;
            ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("error_code", it);
        }
        String string5 = registration.getErrorType();
        if (string5 != null) {
            it = string5;
            boolean bl10 = false;
            ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("error_type", it);
        }
        ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("transactions", registration.getTransactions());
        ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put("retransmits", registration.getRetransmits());
        Object object5 = AttributeUtilKt.toDatabaseAttributes$default(registration.getAttributes(), null, 1, null);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry bl6 = element$iv = iterator2.next();
            boolean bl11 = false;
            String name = (String)bl6.getKey();
            Object value = bl6.getValue();
            ((JsonObject)$this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439).put(name, value);
        }
        if (registration instanceof SipSession) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            long it6;
            Long l2 = ((SipSession)registration).getDuration();
            if (l2 != null) {
                it6 = ((Number)l2).longValue();
                boolean bl12 = false;
                document.put("duration", it6);
            }
            Long l3 = ((SipSession)registration).getOverlappedInterval();
            if (l3 != null) {
                it6 = ((Number)l3).longValue();
                boolean bl13 = false;
                document.put("overlapped_interval", it6);
            }
            Double d = ((SipSession)registration).getOverlappedFraction();
            if (d != null) {
                double it7 = ((Number)d).doubleValue();
                boolean bl14 = false;
                document.put("overlapped_fraction", it7);
            }
            Ref.ObjectRef registrations = new Ref.ObjectRef();
            $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2439 = ((SipSession)registration).getRegistrations();
            Ref.ObjectRef objectRef = registrations;
            boolean $i$f$map2 = false;
            void var35_45 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                JsonObject jsonObject8;
                object5 = (Pair)((Object)item$iv$iv);
                Collection collection2 = destination$iv$iv;
                boolean bl15 = false;
                long createdAt = ((Number)((Pair)object5).component1()).longValue();
                long terminatedAt = ((Number)((Pair)object5).component2()).longValue();
                JsonObject $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2444_u24lambda_u2443 = jsonObject8 = new JsonObject();
                boolean bl16 = false;
                $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2444_u24lambda_u2443.put("created_at", createdAt);
                $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2444_u24lambda_u2443.put("terminated_at", terminatedAt);
                collection2.add(jsonObject8);
            }
            objectRef.element = (List)destination$iv$iv;
            if (upsert) {
                void $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2445;
                JsonObject jsonObject9;
                document = new JsonObject();
                $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446.put("$push", document);
                JsonObject $i$f$map2 = jsonObject9 = new JsonObject();
                objectRef = registrations;
                boolean bl17 = false;
                $this$writeToDatabase_u24lambda_u2447_u24lambda_u2446_u24lambda_u2445.put("$each", registrations.element);
                objectRef.element = jsonObject9;
            }
            document.put("registrations", registrations.element);
        }
        unit = Unit.INSTANCE;
        jsonObject.put(string, jsonObject2);
        JsonObject operation = jsonObject3;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getMongo_bulk_writer(), new Pair<CallSite, JsonObject>((CallSite)((Object)collection), operation), null, 4, null);
    }

    public static /* synthetic */ void writeToDatabase$default(SipRegisterHandler sipRegisterHandler, String string, SipRegistration sipRegistration, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeToDatabase");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        sipRegisterHandler.writeToDatabase(string, sipRegistration, bl);
    }

    public static final /* synthetic */ long access$getAggregationTimeout$p(SipRegisterHandler $this) {
        return $this.aggregationTimeout;
    }

    public static final /* synthetic */ void access$onRemain(SipRegisterHandler $this, long now, SipSession session2) {
        $this.onRemain(now, session2);
    }

    public static final /* synthetic */ void access$terminateSession(SipRegisterHandler $this, SipSession session2) {
        $this.terminateSession(session2);
    }

    public static final /* synthetic */ KLogger access$getLogger$p(SipRegisterHandler $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setHint$p(SipRegisterHandler $this, JsonObject jsonObject) {
        $this.hint = jsonObject;
    }

    public static final /* synthetic */ Vertx access$getVertx$p$s1710471949(SipRegisterHandler $this) {
        return $this.vertx;
    }

    public static final /* synthetic */ PeriodicallyExpiringHashMap access$getActiveSessionCounters$p(SipRegisterHandler $this) {
        return $this.activeSessionCounters;
    }

    static {
        String[] stringArray = new String[]{"caller", "callee", "x_call_id", "recording_mode", "debug"};
        EXCLUDED_ATTRIBUTES = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/sip3/salto/ce/sip/SipRegisterHandler$Companion;", "", "()V", "ACTIVE", "", "EXCLUDED_ATTRIBUTES", "", "getEXCLUDED_ATTRIBUTES", "()Ljava/util/List;", "FAILED", "OVERLAPPED_FRACTION", "OVERLAPPED_INTERVAL", "PREFIX", "REDIRECTED", "REGISTERED", "REMOVED", "REQUEST_DELAY", "UNAUTHORIZED", "UNKNOWN", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEXCLUDED_ATTRIBUTES() {
            return EXCLUDED_ATTRIBUTES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060\u0001R\u00020\u0002J\u001a\u0010&\u001a\u00020$2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0017R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\tR#\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b!\u0010\u0007\"\u0004\b\"\u0010\t\u00a8\u0006("}, d2={"Lio/sip3/salto/ce/sip/SipRegisterHandler$SipSession;", "Lio/sip3/salto/ce/sip/SipRegisterHandler$SipRegistration;", "Lio/sip3/salto/ce/sip/SipRegisterHandler;", "(Lio/sip3/salto/ce/sip/SipRegisterHandler;)V", "duration", "", "getDuration", "()Ljava/lang/Long;", "setDuration", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "overlappedFraction", "", "getOverlappedFraction", "()Ljava/lang/Double;", "setOverlappedFraction", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "overlappedInterval", "getOverlappedInterval", "setOverlappedInterval", "registrations", "", "Lkotlin/Pair;", "getRegistrations", "()Ljava/util/List;", "synced", "", "getSynced", "()Z", "setSynced", "(Z)V", "updatedAt", "getUpdatedAt", "setUpdatedAt", "addSipRegistration", "", "registration", "reset", "lastRegistration", "sip3-salto-ce"})
    public final class SipSession
    extends SipRegistration {
        @Nullable
        private Long updatedAt;
        @Nullable
        private Long duration;
        @Nullable
        private Long overlappedInterval;
        @Nullable
        private Double overlappedFraction;
        private boolean synced;
        @NotNull
        private final List<Pair<Long, Long>> registrations;

        public SipSession() {
            this.registrations = new ArrayList();
        }

        @Nullable
        public final Long getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(@Nullable Long l) {
            this.updatedAt = l;
        }

        @Nullable
        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(@Nullable Long l) {
            this.duration = l;
        }

        @Nullable
        public final Long getOverlappedInterval() {
            return this.overlappedInterval;
        }

        public final void setOverlappedInterval(@Nullable Long l) {
            this.overlappedInterval = l;
        }

        @Nullable
        public final Double getOverlappedFraction() {
            return this.overlappedFraction;
        }

        public final void setOverlappedFraction(@Nullable Double d) {
            this.overlappedFraction = d;
        }

        public final boolean getSynced() {
            return this.synced;
        }

        public final void setSynced(boolean bl) {
            this.synced = bl;
        }

        @NotNull
        public final List<Pair<Long, Long>> getRegistrations() {
            return this.registrations;
        }

        public final void addSipRegistration(@NotNull SipRegistration registration) {
            long l;
            Intrinsics.checkNotNullParameter(registration, "registration");
            this.setTransactions(this.getTransactions() + registration.getTransactions());
            this.setRetransmits(this.getRetransmits() + registration.getRetransmits());
            if (this.getCreatedAt() == 0L) {
                this.setCreatedAt(registration.getCreatedAt());
                this.setSrcAddr(registration.getSrcAddr());
                this.setDstAddr(registration.getDstAddr());
                this.setCallId(registration.getCallId());
                this.setCallee(registration.getCallee());
                this.setCaller(registration.getCaller());
                this.setState(registration.getState());
            } else {
                this.synced = false;
                Long l2 = this.getExpiresAt();
                Intrinsics.checkNotNull(l2);
                this.overlappedInterval = l2 - registration.getCreatedAt();
                if (registration.getExpires() > 0L) {
                    Long l3 = this.overlappedInterval;
                    Intrinsics.checkNotNull(l3);
                    double fraction = (double)l3.longValue() / (double)this.getExpires();
                    Double d = this.overlappedFraction;
                    double d2 = d != null ? d : 0.0;
                    if (fraction > d2) {
                        this.overlappedFraction = fraction;
                    }
                }
            }
            this.setExpiresAt(registration.getExpiresAt());
            this.setExpires(registration.getExpires());
            Long l4 = registration.getCreatedAt();
            Long l5 = registration.getExpiresAt();
            if (l5 != null) {
                l = l5;
            } else {
                Long l6 = registration.getTerminatedAt();
                l = l6 != null ? l6.longValue() : registration.getCreatedAt();
            }
            this.registrations.add(new Pair<Long, Long>(l4, l));
            Map<String, Object> $this$forEach$iv = registration.getAttributes();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator2.next();
                boolean bl = false;
                String name = entry.getKey();
                Object value = entry.getValue();
                this.getAttributes().put(name, value);
            }
        }

        public final void reset(@NotNull Pair<Long, Long> lastRegistration) {
            Intrinsics.checkNotNullParameter(lastRegistration, "lastRegistration");
            this.setCreatedAt(((Number)lastRegistration.getFirst()).longValue());
            this.duration = null;
            this.updatedAt = null;
            this.setRetransmits(0);
            this.setTransactions(0);
            this.registrations.add(lastRegistration);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020ER&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\f\"\u0004\b#\u0010\u000eR\u001c\u0010$\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\f\"\u0004\b&\u0010\u000eR\u001a\u0010'\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001aR\u001e\u0010*\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010/\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001e\"\u0004\b8\u0010 R\u001a\u00109\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\f\"\u0004\b;\u0010\u000eR\u001e\u0010<\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010/\u001a\u0004\b=\u0010,\"\u0004\b>\u0010.R\u001a\u0010?\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00103\"\u0004\bA\u00105\u00a8\u0006F"}, d2={"Lio/sip3/salto/ce/sip/SipRegisterHandler$SipRegistration;", "", "(Lio/sip3/salto/ce/sip/SipRegisterHandler;)V", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "setAttributes", "(Ljava/util/Map;)V", "callId", "getCallId", "()Ljava/lang/String;", "setCallId", "(Ljava/lang/String;)V", "callee", "getCallee", "setCallee", "caller", "getCaller", "setCaller", "createdAt", "", "getCreatedAt", "()J", "setCreatedAt", "(J)V", "dstAddr", "Lio/sip3/salto/ce/domain/Address;", "getDstAddr", "()Lio/sip3/salto/ce/domain/Address;", "setDstAddr", "(Lio/sip3/salto/ce/domain/Address;)V", "errorCode", "getErrorCode", "setErrorCode", "errorType", "getErrorType", "setErrorType", "expires", "getExpires", "setExpires", "expiresAt", "getExpiresAt", "()Ljava/lang/Long;", "setExpiresAt", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "retransmits", "", "getRetransmits", "()I", "setRetransmits", "(I)V", "srcAddr", "getSrcAddr", "setSrcAddr", "state", "getState", "setState", "terminatedAt", "getTerminatedAt", "setTerminatedAt", "transactions", "getTransactions", "setTransactions", "addRegisterTransaction", "", "transaction", "Lio/sip3/salto/ce/sip/SipTransaction;", "sip3-salto-ce"})
    public class SipRegistration {
        @NotNull
        private String state = "unknown";
        private long createdAt;
        @Nullable
        private Long expiresAt;
        @Nullable
        private Long terminatedAt;
        public Address srcAddr;
        public Address dstAddr;
        public String callId;
        public String callee;
        public String caller;
        @Nullable
        private String errorCode;
        @Nullable
        private String errorType;
        private int transactions;
        private int retransmits;
        private long expires;
        @NotNull
        private Map<String, Object> attributes = new LinkedHashMap();

        @NotNull
        public final String getState() {
            return this.state;
        }

        public final void setState(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.state = string;
        }

        public final long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(long l) {
            this.createdAt = l;
        }

        @Nullable
        public final Long getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(@Nullable Long l) {
            this.expiresAt = l;
        }

        @Nullable
        public final Long getTerminatedAt() {
            return this.terminatedAt;
        }

        public final void setTerminatedAt(@Nullable Long l) {
            this.terminatedAt = l;
        }

        @NotNull
        public final Address getSrcAddr() {
            Address address = this.srcAddr;
            if (address != null) {
                return address;
            }
            Intrinsics.throwUninitializedPropertyAccessException("srcAddr");
            return null;
        }

        public final void setSrcAddr(@NotNull Address address) {
            Intrinsics.checkNotNullParameter(address, "<set-?>");
            this.srcAddr = address;
        }

        @NotNull
        public final Address getDstAddr() {
            Address address = this.dstAddr;
            if (address != null) {
                return address;
            }
            Intrinsics.throwUninitializedPropertyAccessException("dstAddr");
            return null;
        }

        public final void setDstAddr(@NotNull Address address) {
            Intrinsics.checkNotNullParameter(address, "<set-?>");
            this.dstAddr = address;
        }

        @NotNull
        public final String getCallId() {
            String string = this.callId;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("callId");
            return null;
        }

        public final void setCallId(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.callId = string;
        }

        @NotNull
        public final String getCallee() {
            String string = this.callee;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("callee");
            return null;
        }

        public final void setCallee(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.callee = string;
        }

        @NotNull
        public final String getCaller() {
            String string = this.caller;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("caller");
            return null;
        }

        public final void setCaller(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.caller = string;
        }

        @Nullable
        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(@Nullable String string) {
            this.errorCode = string;
        }

        @Nullable
        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(@Nullable String string) {
            this.errorType = string;
        }

        public final int getTransactions() {
            return this.transactions;
        }

        public final void setTransactions(int n) {
            this.transactions = n;
        }

        public final int getRetransmits() {
            return this.retransmits;
        }

        public final void setRetransmits(int n) {
            this.retransmits = n;
        }

        public final long getExpires() {
            return this.expires;
        }

        public final void setExpires(long l) {
            this.expires = l;
        }

        @NotNull
        public final Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public final void setAttributes(@NotNull Map<String, Object> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.attributes = map2;
        }

        public final void addRegisterTransaction(@NotNull SipTransaction transaction2) {
            block24: {
                Intrinsics.checkNotNullParameter(transaction2, "transaction");
                int n = this.transactions;
                this.transactions = n + 1;
                this.retransmits += transaction2.getRetransmits();
                if (this.createdAt == 0L) {
                    this.createdAt = transaction2.getCreatedAt();
                    this.setSrcAddr(transaction2.getSrcAddr());
                    this.setDstAddr(transaction2.getDstAddr());
                    this.setCallId(transaction2.getCallId());
                    this.setCallee(transaction2.getCallee());
                    this.setCaller(transaction2.getCaller());
                }
                Integer n2 = transaction2.getExpires();
                if (n2 != null) {
                    int expires = ((Number)n2).intValue();
                    boolean bl = false;
                    if (expires > 0) {
                        this.expires = (long)expires * 1000L;
                        this.expiresAt = transaction2.getCreatedAt() + this.expires;
                    } else {
                        Long l = transaction2.getTerminatedAt();
                        if (l == null) {
                            l = transaction2.getCreatedAt();
                        }
                        this.expiresAt = l;
                    }
                }
                if (Intrinsics.areEqual(this.state, SipRegisterHandler.REGISTERED)) break block24;
                switch (transaction2.getState()) {
                    case "succeed": {
                        String string = SipRegisterHandler.REGISTERED;
                        break;
                    }
                    case "redirected": {
                        String string = SipRegisterHandler.REDIRECTED;
                        break;
                    }
                    case "unauthorized": {
                        String string = SipRegisterHandler.UNAUTHORIZED;
                        break;
                    }
                    case "failed": {
                        String string = SipRegisterHandler.FAILED;
                        break;
                    }
                    default: {
                        String string = this.state = SipRegisterHandler.UNKNOWN;
                    }
                }
            }
            if (!Intrinsics.areEqual(this.state, SipRegisterHandler.UNAUTHORIZED)) {
                Long l = transaction2.getTerminatedAt();
                if (l == null) {
                    l = transaction2.getCreatedAt();
                }
                this.terminatedAt = l;
            }
            this.errorCode = transaction2.getErrorCode();
            this.errorType = transaction2.getErrorType();
            Map<String, Object> $this$forEach$iv = transaction2.getAttributes();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator2.next();
                boolean bl = false;
                String name = entry.getKey();
                Object value = entry.getValue();
                this.attributes.put(name, value);
            }
        }
    }
}

