/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.server;

import io.sip3.commons.vertx.annotations.ConditionalOnProperty;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.server.AbstractServer;
import io.sip3.salto.ce.server.UdpServer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConditionalOnProperty(pointer="/server", matcher=".*: ?\"?udp://.*")
@Instance(singleton=true, worker=true)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/sip3/salto/ce/server/UdpServer;", "Lio/sip3/salto/ce/server/AbstractServer;", "()V", "bufferSize", "", "Ljava/lang/Integer;", "logger", "Lmu/KLogger;", "uri", "Ljava/net/URI;", "readConfig", "", "startServer", "sip3-salto-ce"})
public class UdpServer
extends AbstractServer {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    private URI uri;
    @Nullable
    private Integer bufferSize;

    @Override
    public void readConfig() {
        block3: {
            JsonObject jsonObject;
            JsonObject jsonObject2 = this.config().getJsonObject("server");
            if (jsonObject2 == null) break block3;
            JsonObject server = jsonObject2;
            boolean bl = false;
            Object object = server.getJsonObject("udp");
            JsonObject jsonObject3 = object;
            if (jsonObject3 == null) {
                jsonObject = server;
            } else {
                Intrinsics.checkNotNullExpressionValue(jsonObject3, "server.getJsonObject(\"udp\") ?: server");
                jsonObject = object;
            }
            JsonObject config2 = jsonObject;
            Object object2 = object = config2.getString("uri");
            if (object2 == null) {
                throw new IllegalArgumentException("uri");
            }
            Intrinsics.checkNotNullExpressionValue(object2, "config.getString(\"uri\") \u2026lArgumentException(\"uri\")");
            this.uri = new URI((String)object);
            this.bufferSize = config2.getInteger("buffer_size");
        }
    }

    @Override
    public void startServer() {
        DatagramSocketOptions datagramSocketOptions;
        DatagramSocketOptions $this$startServer_u24lambda_u242 = datagramSocketOptions = new DatagramSocketOptions();
        boolean bl = false;
        URI uRI = this.uri;
        if (uRI == null) {
            Intrinsics.throwUninitializedPropertyAccessException("uri");
            uRI = null;
        }
        String string = uRI.getHost();
        Intrinsics.checkNotNullExpressionValue(string, "uri.host");
        CharSequence charSequence = string;
        $this$startServer_u24lambda_u242.setIpV6(new Regex("\\[.*]").matches(charSequence));
        Integer n = this.bufferSize;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$startServer_u24lambda_u242.setReceiveBufferSize(it);
        }
        DatagramSocketOptions options = datagramSocketOptions;
        ReadStream readStream = this.vertx.createDatagramSocket(options).handler(arg_0 -> UdpServer.startServer$lambda$4(this, options, arg_0));
        URI uRI2 = this.uri;
        if (uRI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("uri");
            uRI2 = null;
        }
        int n2 = uRI2.getPort();
        URI uRI3 = this.uri;
        if (uRI3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("uri");
            uRI3 = null;
        }
        readStream.listen(n2, uRI3.getHost()).onFailure(arg_0 -> UdpServer.startServer$lambda$5(this, arg_0)).onSuccess(arg_0 -> UdpServer.startServer$lambda$6(this, arg_0));
    }

    private static final void startServer$lambda$4(UdpServer this$0, DatagramSocketOptions $options, DatagramPacket packet) {
        String string;
        Address address;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($options, "$options");
        Address $this$startServer_u24lambda_u244_u24lambda_u243 = address = new Address();
        boolean bl = false;
        if ($options.isIpV6()) {
            String string2 = packet.sender().host();
            Intrinsics.checkNotNullExpressionValue(string2, "packet.sender().host()");
            string = StringsKt.substringBefore$default(string2, "%", null, 2, null);
        } else {
            String string3 = packet.sender().host();
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "{\n                      \u2026t()\n                    }");
        }
        $this$startServer_u24lambda_u244_u24lambda_u243.setAddr(string);
        $this$startServer_u24lambda_u244_u24lambda_u243.setPort(packet.sender().port());
        Address sender = address;
        Buffer buffer = packet.data();
        try {
            Intrinsics.checkNotNullExpressionValue(buffer, "buffer");
            this$0.onRawPacket(sender, buffer);
        }
        catch (Exception e) {
            this$0.logger.error(e, (Function0<? extends Object>)startServer.1.1.INSTANCE);
        }
    }

    private static final void startServer$lambda$5(UdpServer this$0, Throwable t) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.error(t, (Function0<? extends Object>)new Function0<Object>(this$0){
            final /* synthetic */ UdpServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                URI uRI = UdpServer.access$getUri$p(this.this$0);
                if (uRI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("uri");
                    uRI = null;
                }
                return "UDP connection failed. URI: " + uRI;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, "t");
        throw t;
    }

    private static final void startServer$lambda$6(UdpServer this$0, DatagramSocket it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.info((Function0<? extends Object>)new Function0<Object>(this$0){
            final /* synthetic */ UdpServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                URI uRI = UdpServer.access$getUri$p(this.this$0);
                if (uRI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("uri");
                    uRI = null;
                }
                return "Listening on " + uRI;
            }
        });
    }

    public static final /* synthetic */ URI access$getUri$p(UdpServer $this) {
        return $this.uri;
    }
}

