/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.recording;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.sip3.commons.domain.payload.RecordingPayload;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.recording.RecordingHandler;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Counter;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/sip3/salto/ce/recording/RecordingHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "aggregationTimeout", "", "bulkSize", "", "expirationDelay", "instances", "logger", "Lmu/KLogger;", "recordings", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "", "Lio/sip3/salto/ce/recording/RecordingHandler$Recording;", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "handle", "", "packet", "Lio/sip3/salto/ce/domain/Packet;", "handleRecording", "recordingPayload", "Lio/sip3/commons/domain/payload/RecordingPayload;", "start", "writeToDatabase", "recording", "Recording", "sip3-salto-ce"})
public class RecordingHandler
extends AbstractVerticle {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    private int instances = 1;
    @NotNull
    private DateTimeFormatter timeSuffix;
    private long expirationDelay;
    private long aggregationTimeout;
    private int bulkSize;
    private PeriodicallyExpiringHashMap<String, Recording> recordings;

    public RecordingHandler() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.expirationDelay = 1000L;
        this.aggregationTimeout = 30000L;
        this.bulkSize = 64;
    }

    @Override
    public void start() {
        Object object = this.config().getJsonObject("vertx");
        if (object != null && (object = ((JsonObject)object).getInteger("instances")) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            this.instances = it;
        }
        String string = this.config().getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(it)");
            this.timeSuffix = dateTimeFormatter;
        }
        JsonObject jsonObject = this.config().getJsonObject("recording");
        if (jsonObject != null) {
            long it;
            Number number;
            JsonObject config2 = jsonObject;
            boolean bl = false;
            Long l = number = config2.getLong("expiration_delay");
            if (l != null) {
                Intrinsics.checkNotNullExpressionValue(l, "getLong(\"expiration_delay\")");
                it = ((Number)number).longValue();
                boolean bl2 = false;
                this.expirationDelay = it;
            }
            Long l2 = number = config2.getLong("aggregation_timeout");
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue(l2, "getLong(\"aggregation_timeout\")");
                it = ((Number)number).longValue();
                boolean bl3 = false;
                this.aggregationTimeout = it;
            }
            Number number2 = number = config2.getInteger("bulk_size");
            if (number2 != null) {
                Intrinsics.checkNotNullExpressionValue(number2, "getInteger(\"bulk_size\")");
                int it2 = ((Number)number).intValue();
                boolean bl4 = false;
                this.bulkSize = it2;
            }
        }
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, Recording, Long>(this){
            final /* synthetic */ RecordingHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull Recording recording2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(recording2, "recording");
                return recording2.getCreatedAt() + RecordingHandler.access$getAggregationTimeout$p(this.this$0);
            }
        }).onExpire((Function2)new Function2<String, Recording, Unit>(this){
            final /* synthetic */ RecordingHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull Recording recording2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(recording2, "recording");
                this.this$0.writeToDatabase(recording2);
            }
        });
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        this.recordings = builder.build(vertx);
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getRec(), arg_0 -> RecordingHandler.start$lambda$6(this, arg_0));
        CoroutineScope coroutineScope = GlobalScope.INSTANCE;
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx2, "vertx");
        CoroutineDispatcher coroutineDispatcher = VertxCoroutineKt.dispatcher(vertx2);
        Intrinsics.checkNotNull(coroutineDispatcher, "null cannot be cast to non-null type kotlin.coroutines.CoroutineContext");
        BuildersKt.launch$default(coroutineScope, coroutineDispatcher, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ RecordingHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        v0 = RecordingHandler.access$getVertx$p$s1307857977(this.this$0).sharedData().getLocalCounter(RoutesCE.Companion.getRec());
                        Intrinsics.checkNotNullExpressionValue(v0, "vertx.sharedData().getLocalCounter(RoutesCE.rec)");
                        this.label = 1;
                        v1 = VertxCoroutineKt.coAwait(v0, this);
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        index = (Counter)v1;
                        var5_4 = RoutesCE.Companion.getRec();
                        var4_5 = RecordingHandler.access$getVertx$p$s1307857977(this.this$0).eventBus();
                        var3_6 = index.getAndIncrement();
                        Intrinsics.checkNotNullExpressionValue(var3_6, "index.andIncrement");
                        this.L$0 = var4_5;
                        this.L$1 = var5_4;
                        this.label = 2;
                        v2 = VertxCoroutineKt.coAwait(var3_6, this);
                        if (v2 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var5_4 = (String)this.L$1;
                        var4_5 = (EventBus)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        var6_7 = v2;
                        var4_5.localConsumer(var5_4 + "_" + var6_7, (Handler<Message<T>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$0(io.sip3.salto.ce.recording.RecordingHandler io.vertx.core.eventbus.Message ), (Lio/vertx/core/eventbus/Message;)V)((RecordingHandler)this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(RecordingHandler this$0, Message event) {
                try {
                    Pair pair = (Pair)event.body();
                    Packet packet = (Packet)pair.component1();
                    RecordingPayload recording2 = (RecordingPayload)pair.component2();
                    this$0.handleRecording(packet, recording2);
                }
                catch (Exception e) {
                    RecordingHandler.access$getLogger$p(this$0).error(e, (Function0<? extends Object>)start.1.1.INSTANCE);
                }
            }
        }, 2, null);
    }

    public void handle(@NotNull Packet packet) {
        RecordingPayload recordingPayload;
        Intrinsics.checkNotNullParameter(packet, "packet");
        RecordingPayload $this$handle_u24lambda_u247 = recordingPayload = new RecordingPayload();
        boolean bl = false;
        ByteBuf payload = Unpooled.wrappedBuffer(packet.getPayload());
        Intrinsics.checkNotNullExpressionValue(payload, "payload");
        $this$handle_u24lambda_u247.decode(payload);
        RecordingPayload recording2 = recordingPayload;
        if (recording2.getType() == 1) {
            Packet packet2;
            Packet $this$handle_u24lambda_u248 = packet2 = new Packet();
            boolean bl2 = false;
            $this$handle_u24lambda_u248.setCreatedAt(packet.getCreatedAt());
            $this$handle_u24lambda_u248.setNanos(packet.getNanos());
            $this$handle_u24lambda_u248.setSrcAddr(packet.getSrcAddr());
            $this$handle_u24lambda_u248.setDstAddr(packet.getDstAddr());
            $this$handle_u24lambda_u248.setProtocolCode((byte)1);
            $this$handle_u24lambda_u248.setSource("sip3");
            $this$handle_u24lambda_u248.setPayload(recording2.getPayload());
            Packet rtcpPacket = packet2;
            EventBus eventBus = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
            EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRtcp(), rtcpPacket, null, 4, null);
        }
        int index = Math.abs(recording2.getCallId().hashCode()) % this.instances;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRec() + "_" + index, new Pair<Packet, RecordingPayload>(packet, recording2), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public void handleRecording(@NotNull Packet packet, @NotNull RecordingPayload recordingPayload) {
        void $this$handleRecording_u24lambda_u2410_u24lambda_u249;
        JsonObject jsonObject;
        Recording recording2;
        Recording recording3;
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(recordingPayload, "recordingPayload");
        String key = recordingPayload.getCallId() + ":" + packet.getSrcAddr().getAddr() + ":" + packet.getSrcAddr().getPort() + ":" + packet.getDstAddr().getAddr() + ":" + packet.getDstAddr().getPort();
        PeriodicallyExpiringHashMap<String, Recording> periodicallyExpiringHashMap = this.recordings;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("recordings");
            periodicallyExpiringHashMap = null;
        }
        Recording $this$handleRecording_u24lambda_u2410 = recording3 = (recording2 = periodicallyExpiringHashMap.getOrPut(key, handleRecording.recording.1.INSTANCE));
        boolean bl = false;
        if ($this$handleRecording_u24lambda_u2410.getCreatedAt() == 0L) {
            $this$handleRecording_u24lambda_u2410.setCreatedAt(packet.getCreatedAt());
            $this$handleRecording_u24lambda_u2410.setSrcAddr(packet.getSrcAddr());
            $this$handleRecording_u24lambda_u2410.setDstAddr(packet.getDstAddr());
            $this$handleRecording_u24lambda_u2410.setCallId(recordingPayload.getCallId());
        }
        JsonObject jsonObject2 = jsonObject = new JsonObject();
        List<JsonObject> list = $this$handleRecording_u24lambda_u2410.getPackets();
        boolean bl2 = false;
        $this$handleRecording_u24lambda_u2410_u24lambda_u249.put("created_at", packet.getCreatedAt());
        $this$handleRecording_u24lambda_u2410_u24lambda_u249.put("nanos", packet.getNanos());
        $this$handleRecording_u24lambda_u2410_u24lambda_u249.put("type", recordingPayload.getType());
        $this$handleRecording_u24lambda_u2410_u24lambda_u249.put("raw_data", new String(recordingPayload.getPayload(), Charsets.ISO_8859_1));
        list.add(jsonObject);
        if (recording2.getPackets().size() >= this.bulkSize) {
            this.writeToDatabase(recording2);
            recording2.setCreatedAt(packet.getCreatedAt());
            recording2.getPackets().clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeToDatabase(@NotNull Recording recording2) {
        void $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        Intrinsics.checkNotNullParameter(recording2, "recording");
        String collection = "rec_raw_" + DateTimeFormatterUtilKt.format(this.timeSuffix, recording2.getCreatedAt());
        JsonObject $this$writeToDatabase_u24lambda_u2414 = jsonObject2 = new JsonObject();
        boolean bl = false;
        JsonObject jsonObject3 = jsonObject = new JsonObject();
        String string = "document";
        JsonObject jsonObject4 = $this$writeToDatabase_u24lambda_u2414;
        boolean bl2 = false;
        $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413.put("created_at", recording2.getCreatedAt());
        Address src = recording2.getSrcAddr();
        $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413.put("src_addr", src.getAddr());
        $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413.put("src_port", src.getPort());
        String string2 = src.getHost();
        if (string2 != null) {
            String it = string2;
            boolean bl3 = false;
            $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413.put("src_host", it);
        }
        Address dst = recording2.getDstAddr();
        $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413.put("dst_addr", dst.getAddr());
        $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413.put("dst_port", dst.getPort());
        String string3 = dst.getHost();
        if (string3 != null) {
            String it = string3;
            boolean bl4 = false;
            $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413.put("dst_host", it);
        }
        $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413.put("call_id", recording2.getCallId());
        $this$writeToDatabase_u24lambda_u2414_u24lambda_u2413.put("packets", CollectionsKt.toList((Iterable)recording2.getPackets()));
        Unit unit = Unit.INSTANCE;
        jsonObject4.put(string, jsonObject);
        JsonObject operation = jsonObject2;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getMongo_bulk_writer(), new Pair<CallSite, JsonObject>((CallSite)((Object)collection), operation), null, 4, null);
    }

    private static final void start$lambda$6(RecordingHandler this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            Packet packet = (Packet)event.body();
            Intrinsics.checkNotNullExpressionValue(packet, "packet");
            this$0.handle(packet);
        }
        catch (Exception e) {
            this$0.logger.error("RecordingHandler 'handle()' failed.", e);
        }
    }

    public static final /* synthetic */ long access$getAggregationTimeout$p(RecordingHandler $this) {
        return $this.aggregationTimeout;
    }

    public static final /* synthetic */ Vertx access$getVertx$p$s1307857977(RecordingHandler $this) {
        return $this.vertx;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(RecordingHandler $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lio/sip3/salto/ce/recording/RecordingHandler$Recording;", "", "()V", "callId", "", "getCallId", "()Ljava/lang/String;", "setCallId", "(Ljava/lang/String;)V", "createdAt", "", "getCreatedAt", "()J", "setCreatedAt", "(J)V", "dstAddr", "Lio/sip3/salto/ce/domain/Address;", "getDstAddr", "()Lio/sip3/salto/ce/domain/Address;", "setDstAddr", "(Lio/sip3/salto/ce/domain/Address;)V", "packets", "", "Lio/vertx/core/json/JsonObject;", "getPackets", "()Ljava/util/List;", "srcAddr", "getSrcAddr", "setSrcAddr", "sip3-salto-ce"})
    public static class Recording {
        private long createdAt;
        public Address srcAddr;
        public Address dstAddr;
        public String callId;
        @NotNull
        private final List<JsonObject> packets = new ArrayList();

        public final long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(long l) {
            this.createdAt = l;
        }

        @NotNull
        public final Address getSrcAddr() {
            Address address = this.srcAddr;
            if (address != null) {
                return address;
            }
            Intrinsics.throwUninitializedPropertyAccessException("srcAddr");
            return null;
        }

        public final void setSrcAddr(@NotNull Address address) {
            Intrinsics.checkNotNullParameter(address, "<set-?>");
            this.srcAddr = address;
        }

        @NotNull
        public final Address getDstAddr() {
            Address address = this.dstAddr;
            if (address != null) {
                return address;
            }
            Intrinsics.throwUninitializedPropertyAccessException("dstAddr");
            return null;
        }

        public final void setDstAddr(@NotNull Address address) {
            Intrinsics.checkNotNullParameter(address, "<set-?>");
            this.dstAddr = address;
        }

        @NotNull
        public final String getCallId() {
            String string = this.callId;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("callId");
            return null;
        }

        public final void setCallId(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.callId = string;
        }

        @NotNull
        public final List<JsonObject> getPackets() {
            return this.packets;
        }
    }
}

