/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.statsd.StatsdLineBuilder;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class FlavorStatsdLineBuilder
implements StatsdLineBuilder {
    private static final String TYPE_COUNT = "c";
    private static final String TYPE_GAUGE = "g";
    private static final String TYPE_HISTOGRAM = "h";
    private static final String TYPE_TIMING = "ms";
    protected final Meter.Id id;
    protected final MeterRegistry.Config config;

    protected FlavorStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config2) {
        this.id = id;
        this.config = config2;
    }

    @Override
    public String count(long amount, Statistic stat) {
        return this.line(Long.toString(amount), stat, TYPE_COUNT);
    }

    @Override
    public String gauge(double amount, Statistic stat) {
        return this.line(DoubleFormat.decimalOrNan(amount), stat, TYPE_GAUGE);
    }

    @Override
    public String histogram(double amount) {
        return this.line(DoubleFormat.decimalOrNan(amount), null, TYPE_HISTOGRAM);
    }

    @Override
    public String timing(double timeMs) {
        return this.line(DoubleFormat.decimalOrNan(timeMs), null, TYPE_TIMING);
    }

    abstract String line(String var1, @Nullable Statistic var2, String var3);

    protected String tags(@Nullable Statistic stat, @Nullable String otherTags, String keyValueSeparator, String preamble) {
        String tags = Stream.of(stat == null ? null : "statistic" + keyValueSeparator + stat.getTagValueRepresentation(), otherTags).filter(Objects::nonNull).collect(Collectors.joining(","));
        if (!tags.isEmpty()) {
            tags = preamble + tags;
        }
        return tags;
    }
}

