/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepDouble;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.shaded.reactor.core.publisher.FluxSink;
import io.micrometer.statsd.StatsdLineBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class StatsdTimer
extends AbstractTimer {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder totalTime = new DoubleAdder();
    private final StatsdLineBuilder lineBuilder;
    private final FluxSink<String> sink;
    private StepDouble max;
    private volatile boolean shutdown;

    StatsdTimer(Meter.Id id, StatsdLineBuilder lineBuilder, FluxSink<String> sink2, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit, long stepMillis) {
        super(id, clock, distributionStatisticConfig, pauseDetector, baseTimeUnit, false);
        this.max = new StepDouble(clock, stepMillis);
        this.lineBuilder = lineBuilder;
        this.sink = sink2;
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        if (!this.shutdown && amount >= 0L) {
            this.count.increment();
            double msAmount = TimeUtils.convert(amount, unit, TimeUnit.MILLISECONDS);
            this.totalTime.add(msAmount);
            this.max.getCurrent().add(Math.max(msAmount - this.max.getCurrent().doubleValue(), 0.0));
            this.sink.next(this.lineBuilder.timing(msAmount));
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.convert(this.totalTime.doubleValue(), TimeUnit.MILLISECONDS, unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return TimeUtils.convert((Double)this.max.poll(), TimeUnit.MILLISECONDS, unit);
    }

    void shutdown() {
        this.shutdown = true;
    }
}

