/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.statsd.StatsdFlavor;
import io.micrometer.statsd.StatsdProtocol;
import java.time.Duration;

public interface StatsdConfig
extends MeterRegistryConfig {
    public static final StatsdConfig DEFAULT = k -> null;

    @Override
    default public String prefix() {
        return "statsd";
    }

    default public StatsdFlavor flavor() {
        return PropertyValidator.getEnum(this, StatsdFlavor.class, "flavor").orElse(StatsdFlavor.DATADOG);
    }

    default public boolean enabled() {
        return PropertyValidator.getBoolean(this, "enabled").orElse(true);
    }

    default public String host() {
        return PropertyValidator.getString(this, "host").orElse("localhost");
    }

    default public int port() {
        return PropertyValidator.getInteger(this, "port").orElse(8125);
    }

    default public StatsdProtocol protocol() {
        return PropertyValidator.getEnum(this, StatsdProtocol.class, "protocol").orElse(StatsdProtocol.UDP);
    }

    default public int maxPacketLength() {
        return PropertyValidator.getInteger(this, "maxPacketLength").orElse(1400);
    }

    default public Duration pollingFrequency() {
        return PropertyValidator.getDuration(this, "pollingFrequency").orElse(Duration.ofSeconds(10L));
    }

    @Deprecated
    default public int queueSize() {
        return PropertyValidator.getInteger(this, "queueSize").orElse(Integer.MAX_VALUE);
    }

    default public Duration step() {
        return PropertyValidator.getDuration(this, "step").orElse(Duration.ofMinutes(1L));
    }

    default public boolean publishUnchangedMeters() {
        return PropertyValidator.getBoolean(this, "publishUnchangedMeters").orElse(true);
    }

    default public boolean buffered() {
        return PropertyValidator.getBoolean(this, "buffered").orElse(true);
    }

    @Override
    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll(this, MeterRegistryConfigValidator.checkRequired("flavor", StatsdConfig::flavor), MeterRegistryConfigValidator.checkRequired("host", StatsdConfig::host), MeterRegistryConfigValidator.check("port", StatsdConfig::port), MeterRegistryConfigValidator.checkRequired("protocol", StatsdConfig::protocol), MeterRegistryConfigValidator.checkRequired("pollingFrequency", StatsdConfig::pollingFrequency), MeterRegistryConfigValidator.checkRequired("step", StatsdConfig::step));
    }
}

