/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelOption;
import io.micrometer.shaded.io.netty.handler.logging.LogLevel;
import io.micrometer.shaded.io.netty.handler.logging.LoggingHandler;
import io.micrometer.shaded.io.netty.resolver.AddressResolverGroup;
import io.micrometer.shaded.reactor.netty.ChannelPipelineConfigurer;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.tcp.SslProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.netty.tcp.TcpResources;
import io.micrometer.shaded.reactor.netty.transport.ClientTransportConfig;
import io.micrometer.shaded.reactor.netty.transport.logging.AdvancedByteBufFormat;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class TcpClientConfig
extends ClientTransportConfig<TcpClientConfig> {
    SslProvider sslProvider;
    static final ChannelOperations.OnSetup DEFAULT_OPS = (ch, c, msg) -> new ChannelOperations(ch, c);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(TcpClient.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());
    static final boolean SSL_DEBUG = Boolean.parseBoolean(System.getProperty("io.micrometer.shaded.reactor.netty.tcp.ssl.client.debug", "false"));

    @Override
    public int channelHash() {
        int result2 = super.channelHash();
        result2 = 31 * result2 + Objects.hashCode(this.sslProvider);
        return result2;
    }

    @Override
    public ChannelOperations.OnSetup channelOperationsProvider() {
        return DEFAULT_OPS;
    }

    public final boolean isSecure() {
        return this.sslProvider != null;
    }

    @Nullable
    public SslProvider sslProvider() {
        return this.sslProvider;
    }

    TcpClientConfig(ConnectionProvider connectionProvider, Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> remoteAddress) {
        super(connectionProvider, options, remoteAddress);
    }

    TcpClientConfig(TcpClientConfig parent) {
        super(parent);
        this.sslProvider = parent.sslProvider;
    }

    @Override
    protected AddressResolverGroup<?> defaultAddressResolverGroup() {
        return TcpResources.get().getOrCreateDefaultResolver();
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected LoopResources defaultLoopResources() {
        return TcpResources.get();
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerTcpClientMetricsRecorder.INSTANCE;
    }

    @Override
    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        ChannelPipelineConfigurer _default = super.defaultOnChannelInit();
        if (this.sslProvider != null) {
            return _default.then(new TcpClientChannelInitializer(this.sslProvider));
        }
        return _default;
    }

    static final class TcpClientChannelInitializer
    implements ChannelPipelineConfigurer {
        final SslProvider sslProvider;

        TcpClientChannelInitializer(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
        }

        @Override
        public void onChannelInit(ConnectionObserver connectionObserver, Channel channel, @Nullable SocketAddress remoteAddress) {
            this.sslProvider.addSslHandler(channel, remoteAddress, SSL_DEBUG);
        }
    }

    static final class MicrometerTcpClientMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerTcpClientMetricsRecorder INSTANCE = new MicrometerTcpClientMetricsRecorder();

        MicrometerTcpClientMetricsRecorder() {
            super("io.micrometer.shaded.reactor.netty.tcp.client", "tcp");
        }
    }
}

