/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.resources;

import io.micrometer.observation.Observation;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelInitializer;
import io.micrometer.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.micrometer.shaded.io.netty.resolver.AddressResolverGroup;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.netty.ChannelBindException;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.Metrics;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.transport.AddressUtils;
import io.micrometer.shaded.reactor.netty.transport.TransportConfig;
import io.micrometer.shaded.reactor.netty.transport.TransportConnector;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.Context;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;

final class NewConnectionProvider
implements ConnectionProvider {
    static final Logger log = Loggers.getLogger(NewConnectionProvider.class);
    static final NewConnectionProvider INSTANCE = new NewConnectionProvider();

    NewConnectionProvider() {
    }

    @Override
    public Mono<? extends Connection> acquire(TransportConfig config2, ConnectionObserver observer, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return Mono.create((MonoSink<T> sink2) -> {
            SocketAddress remote = null;
            if (remoteAddress != null) {
                remote = Objects.requireNonNull((SocketAddress)remoteAddress.get(), "Remote Address supplier returned null");
            }
            if (remote != null && resolverGroup != null) {
                Observation currentObservation;
                Context currentContext = Context.of(sink2.contextView());
                if (config2.metricsRecorder() != null && io.micrometer.shaded.reactor.netty.internal.util.Metrics.isMicrometerAvailable() && (currentObservation = Metrics.currentObservation(currentContext)) != null) {
                    currentContext = Metrics.updateContext(currentContext, currentObservation);
                }
                NewConnectionObserver connectionObserver = new NewConnectionObserver((MonoSink<Connection>)sink2, currentContext, observer);
                ChannelInitializer<Channel> channelInitializer = config2.channelInitializer(connectionObserver, remote, false);
                DisposableConnect disposableConnect = new DisposableConnect((MonoSink<Connection>)sink2, currentContext, config2.bindAddress());
                TransportConnector.connect(config2, remote, resolverGroup, channelInitializer, currentContext).subscribe(disposableConnect);
            } else {
                InetSocketAddress localInet;
                Objects.requireNonNull(config2.bindAddress(), "bindAddress");
                SocketAddress local = Objects.requireNonNull(config2.bindAddress().get(), "Bind Address supplier returned null");
                if (local instanceof InetSocketAddress && (localInet = (InetSocketAddress)local).isUnresolved()) {
                    local = AddressUtils.createResolved(localInet.getHostName(), localInet.getPort());
                }
                NewConnectionObserver connectionObserver = new NewConnectionObserver((MonoSink<Connection>)sink2, observer);
                ChannelInitializer<Channel> channelInitializer = config2.channelInitializer(connectionObserver, null, true);
                DisposableConnect disposableConnect = new DisposableConnect((MonoSink<Connection>)sink2, config2.bindAddress());
                TransportConnector.bind(config2, channelInitializer, local, local instanceof DomainSocketAddress).subscribe(disposableConnect);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public int maxConnections() {
        return 1;
    }

    static final class NewConnectionObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final ConnectionObserver obs;

        NewConnectionObserver(MonoSink<Connection> sink2, ConnectionObserver obs) {
            this(sink2, Context.of(sink2.contextView()), obs);
        }

        NewConnectionObserver(MonoSink<Connection> sink2, Context currentContext, ConnectionObserver obs) {
            this.sink = sink2;
            this.currentContext = currentContext;
            this.obs = obs;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(connection.channel(), "onStateChange({}, {})"), newState, connection);
            }
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success(connection);
            } else if (newState == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive()) {
                connection.channel().close();
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public void onUncaughtException(Connection c, Throwable error) {
            this.sink.error(error);
            this.obs.onUncaughtException(c, error);
        }
    }

    static final class DisposableConnect
    implements CoreSubscriber<Channel>,
    Disposable {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final Supplier<? extends SocketAddress> bindAddress;
        Subscription subscription;

        DisposableConnect(MonoSink<Connection> sink2, @Nullable Supplier<? extends SocketAddress> bindAddress) {
            this(sink2, Context.of(sink2.contextView()), bindAddress);
        }

        DisposableConnect(MonoSink<Connection> sink2, Context currentContext, @Nullable Supplier<? extends SocketAddress> bindAddress) {
            this.sink = sink2;
            this.currentContext = currentContext;
            this.bindAddress = bindAddress;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void dispose() {
            this.subscription.cancel();
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable t) {
            if (this.bindAddress != null && (t instanceof BindException || t instanceof IOException && t.getMessage() != null && t.getMessage().contains("bind(..)"))) {
                this.sink.error(ChannelBindException.fail(this.bindAddress.get(), null));
            } else {
                this.sink.error(t);
            }
        }

        @Override
        public void onNext(Channel channel) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Connected new channel"));
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                this.sink.onCancel(this);
                s.request(Long.MAX_VALUE);
            }
        }
    }
}

