/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.ParallelFlux;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.Objects;

final class ParallelLift<I, O>
extends ParallelFlux<O>
implements Scannable {
    final Operators.LiftFunction<I, O> liftFunction;
    final ParallelFlux<I> source;

    ParallelLift(ParallelFlux<I> p, Operators.LiftFunction<I, O> liftFunction) {
        this.source = Objects.requireNonNull(p, "source");
        this.liftFunction = liftFunction;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.from(this.source).scanUnsafe(key);
        }
        if (key == Scannable.Attr.LIFTER) {
            return this.liftFunction.name;
        }
        return null;
    }

    @Override
    public String stepName() {
        if (this.source instanceof Scannable) {
            return Scannable.from(this.source).stepName();
        }
        return Scannable.super.stepName();
    }

    @Override
    public void subscribe(CoreSubscriber<? super O>[] s) {
        CoreSubscriber[] subscribers = new CoreSubscriber[this.parallelism()];
        for (int i2 = 0; i2 < subscribers.length; ++i2) {
            subscribers[i2] = Objects.requireNonNull(this.liftFunction.lifter.apply(this.source, s[i2]), "Lifted subscriber MUST NOT be null");
        }
        this.source.subscribe(subscribers);
    }
}

