/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.FluxTimeout;
import io.micrometer.shaded.reactor.core.publisher.InternalMonoOperator;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import java.util.Objects;
import java.util.function.Function;

final class MonoTimeout<T, U, V>
extends InternalMonoOperator<T, T> {
    final Publisher<U> firstTimeout;
    final Publisher<? extends T> other;
    final String timeoutDescription;
    static final Function NEVER = e -> Flux.never();

    MonoTimeout(Mono<? extends T> source2, Publisher<U> firstTimeout, String timeoutDescription) {
        super(source2);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = null;
        this.timeoutDescription = timeoutDescription;
    }

    MonoTimeout(Mono<? extends T> source2, Publisher<U> firstTimeout, Publisher<? extends T> other) {
        super(source2);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = Objects.requireNonNull(other, "other");
        this.timeoutDescription = null;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new FluxTimeout.TimeoutMainSubscriber(actual, this.firstTimeout, NEVER, this.other, FluxTimeout.addNameToTimeoutDescription(this.source, this.timeoutDescription));
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

