/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.context.ContextSnapshot;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.observability.SignalListener;
import io.micrometer.shaded.reactor.core.observability.SignalListenerFactory;
import io.micrometer.shaded.reactor.core.publisher.ContextPropagation;
import io.micrometer.shaded.reactor.core.publisher.FluxTapRestoringThreadLocals;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoOperator;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.Context;

final class MonoTapRestoringThreadLocals<T, STATE>
extends MonoOperator<T, T> {
    final SignalListenerFactory<T, STATE> tapFactory;
    final STATE commonTapState;

    MonoTapRestoringThreadLocals(Mono<? extends T> source2, SignalListenerFactory<T, STATE> tapFactory) {
        super(source2);
        this.tapFactory = tapFactory;
        this.commonTapState = tapFactory.initializePublisherState(source2);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Context alteredContext;
        SignalListener<T> signalListener;
        try {
            signalListener = this.tapFactory.createListener(this.source, actual.currentContext().readOnly(), this.commonTapState);
        }
        catch (Throwable generatorError) {
            Operators.error(actual, generatorError);
            return;
        }
        try {
            signalListener.doFirst();
        }
        catch (Throwable listenerError) {
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return;
        }
        try {
            alteredContext = signalListener.addToContext(actual.currentContext());
        }
        catch (Throwable e) {
            signalListener.handleListenerError(new IllegalStateException("Unable to augment tap Context at construction via addToContext", e));
            alteredContext = actual.currentContext();
        }
        try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(alteredContext);){
            this.source.subscribe(new FluxTapRestoringThreadLocals.TapSubscriber<T>(actual, signalListener, alteredContext));
        }
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return -1;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

