/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.InnerOperator;
import io.micrometer.shaded.reactor.core.publisher.InternalFluxOperator;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.function.BiFunction;

final class FluxIndex<T, I>
extends InternalFluxOperator<T, I> {
    private final BiFunction<? super Long, ? super T, ? extends I> indexMapper;

    FluxIndex(Flux<T> source2, BiFunction<? super Long, ? super T, ? extends I> indexMapper) {
        super(source2);
        this.indexMapper = NullSafeIndexMapper.create(Objects.requireNonNull(indexMapper, "indexMapper must be non null"));
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super I> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            return new IndexConditionalSubscriber<T, I>(cs, this.indexMapper);
        }
        return new IndexSubscriber<T, I>(actual, this.indexMapper);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static class NullSafeIndexMapper<T, I>
    implements BiFunction<Long, T, I> {
        private final BiFunction<? super Long, ? super T, ? extends I> indexMapper;

        private NullSafeIndexMapper(BiFunction<? super Long, ? super T, ? extends I> indexMapper) {
            this.indexMapper = indexMapper;
        }

        @Override
        public I apply(Long i2, T t) {
            I typedIndex = this.indexMapper.apply((Long)((Long)i2), (Long)t);
            if (typedIndex == null) {
                throw new NullPointerException("indexMapper returned a null value at raw index " + i2 + " for value " + t);
            }
            return typedIndex;
        }

        static <T, I> BiFunction<? super Long, ? super T, ? extends I> create(BiFunction<? super Long, ? super T, ? extends I> indexMapper) {
            if (indexMapper == Flux.TUPLE2_BIFUNCTION) {
                return indexMapper;
            }
            return new NullSafeIndexMapper<T, I>(indexMapper);
        }
    }

    static final class IndexConditionalSubscriber<T, I>
    implements InnerOperator<T, I>,
    Fuseable.ConditionalSubscriber<T> {
        final Fuseable.ConditionalSubscriber<? super I> actual;
        final BiFunction<? super Long, ? super T, ? extends I> indexMapper;
        Subscription s;
        boolean done;
        long index;

        IndexConditionalSubscriber(Fuseable.ConditionalSubscriber<? super I> cs, BiFunction<? super Long, ? super T, ? extends I> indexMapper) {
            this.actual = cs;
            this.indexMapper = indexMapper;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            I typedIndex;
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return true;
            }
            long i2 = this.index;
            try {
                typedIndex = this.indexMapper.apply((Long)((Long)Long.valueOf(i2)), (Long)t);
                this.index = i2 + 1L;
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return true;
            }
            return this.actual.tryOnNext(typedIndex);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            long i2 = this.index;
            try {
                I typedIndex = this.indexMapper.apply((Long)((Long)Long.valueOf(i2)), (Long)t);
                this.index = i2 + 1L;
                this.actual.onNext(typedIndex);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.done) {
                Operators.onErrorDropped(throwable, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super I> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }
    }

    static final class IndexSubscriber<T, I>
    implements InnerOperator<T, I> {
        final CoreSubscriber<? super I> actual;
        final BiFunction<? super Long, ? super T, ? extends I> indexMapper;
        boolean done;
        Subscription s;
        long index = 0L;

        IndexSubscriber(CoreSubscriber<? super I> actual, BiFunction<? super Long, ? super T, ? extends I> indexMapper) {
            this.actual = actual;
            this.indexMapper = indexMapper;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            long i2 = this.index;
            try {
                I typedIndex = this.indexMapper.apply((Long)((Long)Long.valueOf(i2)), (Long)t);
                this.index = i2 + 1L;
                this.actual.onNext(typedIndex);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super I> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }
    }
}

