/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jetty;

import io.micrometer.common.KeyValue;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.core.instrument.binder.http.Outcome;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpStatus;

public final class JettyClientKeyValues {
    private static final KeyValue URI_NOT_FOUND = KeyValue.of("uri", "NOT_FOUND");
    private static final KeyValue URI_REDIRECTION = KeyValue.of("uri", "REDIRECTION");
    private static final KeyValue URI_ROOT = KeyValue.of("uri", "root");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of("exception", "None");
    private static final KeyValue EXCEPTION_UNKNOWN = KeyValue.of("exception", "UNKNOWN");
    private static final KeyValue METHOD_UNKNOWN = KeyValue.of("method", "UNKNOWN");
    private static final KeyValue HOST_UNKNOWN = KeyValue.of("host", "UNKNOWN");
    private static final KeyValue STATUS_UNKNOWN = KeyValue.of("status", "UNKNOWN");
    private static final Pattern TRAILING_SLASH_PATTERN = Pattern.compile("/$");
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");
    private static final KeyValue OUTCOME_UNKNOWN = KeyValue.of("outcome", "UNKNOWN");

    private JettyClientKeyValues() {
    }

    public static KeyValue method(Request request) {
        return request != null ? KeyValue.of("method", request.getMethod()) : METHOD_UNKNOWN;
    }

    public static KeyValue host(Request request) {
        return request != null ? KeyValue.of("host", request.getHost()) : HOST_UNKNOWN;
    }

    public static KeyValue status(@Nullable Result result2) {
        return result2 != null ? KeyValue.of("status", Integer.toString(result2.getResponse().getStatus())) : STATUS_UNKNOWN;
    }

    public static KeyValue uri(Request request, @Nullable Result result2, BiFunction<Request, Result, String> successfulUriPattern) {
        if (result2 != null && result2.getResponse() != null) {
            int status = result2.getResponse().getStatus();
            if (HttpStatus.isRedirection((int)status)) {
                return URI_REDIRECTION;
            }
            if (status == 404) {
                return URI_NOT_FOUND;
            }
        }
        String matchingPattern = successfulUriPattern.apply(request, result2);
        if ((matchingPattern = MULTIPLE_SLASH_PATTERN.matcher(matchingPattern).replaceAll("/")).equals("/")) {
            return URI_ROOT;
        }
        matchingPattern = TRAILING_SLASH_PATTERN.matcher(matchingPattern).replaceAll("");
        return KeyValue.of("uri", matchingPattern);
    }

    public static KeyValue exception(@Nullable Result result2) {
        String simpleName;
        int status;
        if (result2 == null) {
            return EXCEPTION_UNKNOWN;
        }
        Throwable exception = result2.getFailure();
        if (exception == null) {
            return EXCEPTION_NONE;
        }
        if (result2.getResponse() != null && ((status = result2.getResponse().getStatus()) == 404 || HttpStatus.isRedirection((int)status))) {
            return EXCEPTION_NONE;
        }
        if (exception.getCause() != null) {
            exception = exception.getCause();
        }
        return KeyValue.of("exception", StringUtils.isNotEmpty(simpleName = exception.getClass().getSimpleName()) ? simpleName : exception.getClass().getName());
    }

    public static KeyValue outcome(@Nullable Result result2) {
        if (result2 == null) {
            return OUTCOME_UNKNOWN;
        }
        return Outcome.forStatus(result2.getResponse().getStatus()).asKeyValue();
    }
}

