/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;

final class TrampolineClosure<V>
extends Closure<V> {
    private static final long serialVersionUID = -4096349147398489925L;
    private final Closure<V> original;

    TrampolineClosure(Closure<V> original) {
        super(original.getOwner(), original.getDelegate());
        this.original = original;
    }

    @Override
    public int getMaximumNumberOfParameters() {
        return this.original.maximumNumberOfParameters;
    }

    @Override
    public Class[] getParameterTypes() {
        return this.original.parameterTypes;
    }

    @Override
    public V call() {
        return this.loop(this.original.call());
    }

    @Override
    public V call(Object arguments) {
        return this.loop(this.original.call(arguments));
    }

    @Override
    public V call(Object ... args2) {
        return this.loop(this.original.call(args2));
    }

    private V loop(Object lastResult) {
        Object result2 = lastResult;
        while (result2 instanceof TrampolineClosure) {
            result2 = ((TrampolineClosure)result2).original.call();
        }
        return (V)result2;
    }

    @Override
    public Closure<V> trampoline(Object ... args2) {
        return new TrampolineClosure<V>(this.original.curry(args2));
    }

    @Override
    public Closure<V> trampoline() {
        return this;
    }
}

