/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.NamingThreadFactory;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;

public class MultiPipelineExecutor<K> {
    private ExecutorService executor;
    private ConcurrentHashMap<K, SemaphoreLinkedList<SemaphoreRunnable<K>>> map = new ConcurrentHashMap();

    public MultiPipelineExecutor(int threads) {
        this.executor = Executors.newFixedThreadPool(threads, new NamingThreadFactory("jain_sip_multi_pipeline_executor"));
    }

    public synchronized void addTask(K key, Runnable task) {
        SemaphoreLinkedList<SemaphoreRunnable<Object>> list = this.map.get(key);
        if (list == null) {
            list = new SemaphoreLinkedList();
            this.map.put(key, list);
        }
        list.addFirst(new SemaphoreRunnable(task, list.semaphore, this));
        this.notifyAll();
    }

    public synchronized void processTasks() {
        try {
            this.wait();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Enumeration<K> keys2 = this.map.keys();
        while (keys2.hasMoreElements()) {
            K key = keys2.nextElement();
            SemaphoreLinkedList<SemaphoreRunnable<K>> e = this.map.get(key);
            if (e.isEmpty() || !e.semaphore.tryAcquire()) continue;
            Runnable task = (Runnable)e.pollLast();
            this.executor.execute(task);
        }
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public static class SemaphoreRunnable<K>
    implements Runnable {
        protected Runnable wrappedTask;
        protected Semaphore semaphore;
        protected MultiPipelineExecutor<K> parent;

        public SemaphoreRunnable(Runnable task, Semaphore semaphore, MultiPipelineExecutor<K> parent) {
            this.wrappedTask = task;
            this.semaphore = semaphore;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.wrappedTask.run();
            }
            finally {
                this.semaphore.release();
                this.parent.notifyAll();
            }
        }
    }

    public static class SemaphoreLinkedList<A>
    extends LinkedList<A> {
        private static final long serialVersionUID = 1L;
        Semaphore semaphore = new Semaphore(1);
    }
}

