/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.javax.sip.LogRecord;

class MessageLog
implements LogRecord {
    private String message;
    private String source;
    private String destination;
    private long timeStamp;
    private boolean isSender;
    private String firstLine;
    private String tid;
    private String callId;
    private long timeStampHeaderValue;

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof MessageLog)) {
            return false;
        }
        MessageLog otherLog = (MessageLog)other;
        return otherLog.message.equals(this.message) && otherLog.timeStamp == this.timeStamp;
    }

    public MessageLog(String message, String source2, String destination, String timeStamp, boolean isSender, String firstLine, String tid, String callId, long timeStampHeaderValue) {
        if (message == null || message.equals("")) {
            throw new IllegalArgumentException("null msg");
        }
        this.message = message;
        this.source = source2;
        this.destination = destination;
        try {
            long ts = Long.parseLong(timeStamp);
            if (ts < 0L) {
                throw new IllegalArgumentException("Bad time stamp ");
            }
            this.timeStamp = ts;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Bad number format " + timeStamp);
        }
        this.isSender = isSender;
        this.firstLine = firstLine;
        this.tid = tid;
        this.callId = callId;
        this.timeStampHeaderValue = timeStampHeaderValue;
    }

    public MessageLog(String message, String source2, String destination, long timeStamp, boolean isSender, String firstLine, String tid, String callId, long timestampVal) {
        if (message == null || message.equals("")) {
            throw new IllegalArgumentException("null msg");
        }
        this.message = message;
        this.source = source2;
        this.destination = destination;
        if (timeStamp < 0L) {
            throw new IllegalArgumentException("negative ts");
        }
        this.timeStamp = timeStamp;
        this.isSender = isSender;
        this.firstLine = firstLine;
        this.tid = tid;
        this.callId = callId;
        this.timeStampHeaderValue = timestampVal;
    }

    @Override
    public String toString() {
        String log = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + this.timeStamp + "\"" + (this.timeStampHeaderValue != 0L ? "\ntimeStamp = \"" + this.timeStampHeaderValue + "\"" : "") + "\nisSender=\"" + this.isSender + "\" \ntransactionId=\"" + this.tid + "\" \ncallId=\"" + this.callId + "\" \nfirstLine=\"" + this.firstLine.trim() + "\"" + " \n>\n";
        log = log + "<![CDATA[";
        log = log + this.message;
        log = log + "]]>\n";
        log = log + "</message>\n";
        return log;
    }
}

