/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.metrics;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.util.Utils;
import java.util.Map;

public final class Gauge
implements Metric {
    private final String name;
    private final double value;
    private final long timestamp;
    private final Map<String, Object> attributes;

    public Gauge(String name, double value, long timestamp, Attributes attributes) {
        this.name = Utils.verifyNonNull(name);
        this.value = value;
        this.timestamp = timestamp;
        this.attributes = Utils.verifyNonNull(attributes).asMap();
    }

    public double getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gauge gauge = (Gauge)o;
        if (Double.compare(gauge.getValue(), this.getValue()) != 0) {
            return false;
        }
        if (this.getTimestamp() != gauge.getTimestamp()) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(gauge.getName()) : gauge.getName() != null) {
            return false;
        }
        return this.getAttributes() != null ? this.getAttributes().equals(gauge.getAttributes()) : gauge.getAttributes() == null;
    }

    public int hashCode() {
        int result2 = this.getName() != null ? this.getName().hashCode() : 0;
        long temp = Double.doubleToLongBits(this.getValue());
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        result2 = 31 * result2 + (int)(this.getTimestamp() ^ this.getTimestamp() >>> 32);
        result2 = 31 * result2 + (this.getAttributes() != null ? this.getAttributes().hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "Gauge{name='" + this.name + '\'' + ", value=" + this.value + ", timestamp=" + this.timestamp + ", attributes=" + this.attributes + '}';
    }
}

