/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import java.util.function.Supplier;

public interface MetricBatchSenderFactory {
    default public MetricBatchSender createBatchSender(String apiKey) {
        SenderConfiguration.SenderConfigurationBuilder configuration = MetricBatchSender.configurationBuilder().apiKey(apiKey).httpPoster(this.getPoster());
        return MetricBatchSender.create(configuration.build());
    }

    default public SenderConfiguration.SenderConfigurationBuilder configureWith(BaseConfig baseConfig) {
        return this.configureWith(baseConfig.getApiKey()).auditLoggingEnabled(baseConfig.isAuditLoggingEnabled()).secondaryUserAgent(baseConfig.getSecondaryUserAgent());
    }

    default public SenderConfiguration.SenderConfigurationBuilder configureWith(String apiKey) {
        return MetricBatchSender.configurationBuilder().apiKey(apiKey).httpPoster(this.getPoster());
    }

    public HttpPoster getPoster();

    public static MetricBatchSenderFactory fromHttpImplementation(Supplier<HttpPoster> creator) {
        return creator::get;
    }
}

