/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.MongoSocketException;
import com.mongodb.ServerAddress;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.Stream;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.TlsChannelStreamFactoryFactory;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.mongodb.internal.connection.AsynchronousChannelStream;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.io.Closeable;
import java.nio.channels.CompletionHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class KeyManagementService
implements Closeable {
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final Map<String, SSLContext> kmsProviderSslContextMap;
    private final int timeoutMillis;
    private final TlsChannelStreamFactoryFactory tlsChannelStreamFactoryFactory;

    KeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap, int timeoutMillis) {
        this.kmsProviderSslContextMap = kmsProviderSslContextMap;
        this.tlsChannelStreamFactoryFactory = new TlsChannelStreamFactoryFactory();
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public void close() {
        this.tlsChannelStreamFactoryFactory.close();
    }

    Mono<Void> decryptKey(final MongoKeyDecryptor keyDecryptor) {
        SocketSettings socketSettings = SocketSettings.builder().connectTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS).build();
        StreamFactory streamFactory = this.tlsChannelStreamFactoryFactory.create(socketSettings, SslSettings.builder().enabled(true).context(this.kmsProviderSslContextMap.get(keyDecryptor.getKmsProvider())).build());
        ServerAddress serverAddress = new ServerAddress(keyDecryptor.getHostName());
        LOGGER.info("Connecting to KMS server at " + serverAddress);
        return Mono.create(sink2 -> {
            final Stream stream2 = streamFactory.create(serverAddress);
            stream2.openAsync(new AsyncCompletionHandler<Void>(){

                @Override
                public void completed(Void ignored) {
                    KeyManagementService.this.streamWrite(stream2, keyDecryptor, sink2);
                }

                @Override
                public void failed(Throwable t) {
                    stream2.close();
                    sink2.error(t);
                }
            });
        }).onErrorMap(this::unWrapException);
    }

    private void streamWrite(final Stream stream2, final MongoKeyDecryptor keyDecryptor, final MonoSink<Void> sink2) {
        List<ByteBuf> byteBufs = Collections.singletonList(new ByteBufNIO(keyDecryptor.getMessage()));
        stream2.writeAsync(byteBufs, new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(Void aVoid) {
                KeyManagementService.this.streamRead(stream2, keyDecryptor, sink2);
            }

            @Override
            public void failed(Throwable t) {
                stream2.close();
                sink2.error(t);
            }
        });
    }

    private void streamRead(final Stream stream2, final MongoKeyDecryptor keyDecryptor, final MonoSink<Void> sink2) {
        int bytesNeeded = keyDecryptor.bytesNeeded();
        if (bytesNeeded > 0) {
            AsynchronousChannelStream asyncStream = (AsynchronousChannelStream)stream2;
            final ByteBuf buffer = asyncStream.getBuffer(bytesNeeded);
            asyncStream.getChannel().read(buffer.asNIO(), asyncStream.getSettings().getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, null, new CompletionHandler<Integer, Void>(){

                @Override
                public void completed(Integer integer, Void aVoid) {
                    buffer.flip();
                    try {
                        keyDecryptor.feed(buffer.asNIO());
                        buffer.release();
                        KeyManagementService.this.streamRead(stream2, keyDecryptor, sink2);
                    }
                    catch (Throwable t) {
                        sink2.error(t);
                    }
                }

                @Override
                public void failed(Throwable t, Void aVoid) {
                    buffer.release();
                    stream2.close();
                    sink2.error(t);
                }
            });
        } else {
            stream2.close();
            sink2.success();
        }
    }

    private Throwable unWrapException(Throwable t) {
        return t instanceof MongoSocketException ? t.getCause() : t;
    }
}

