/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.crypt.capi.MongoCryptContext;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoDataKeyOptions;
import com.mongodb.crypt.capi.MongoExplicitEncryptOptions;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.mongodb.crypt.capi.MongoRewrapManyDataKeyOptions;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.internal.crypt.CollectionInfoRetriever;
import com.mongodb.reactivestreams.client.internal.crypt.CommandMarker;
import com.mongodb.reactivestreams.client.internal.crypt.KeyManagementService;
import com.mongodb.reactivestreams.client.internal.crypt.KeyRetriever;
import java.io.Closeable;
import java.util.Map;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class Crypt
implements Closeable {
    private static final RawBsonDocument EMPTY_RAW_BSON_DOCUMENT = RawBsonDocument.parse("{}");
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final MongoCrypt mongoCrypt;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final CollectionInfoRetriever collectionInfoRetriever;
    private final CommandMarker commandMarker;
    private final KeyRetriever keyRetriever;
    private final KeyManagementService keyManagementService;
    private final boolean bypassAutoEncryption;
    @Nullable
    private final MongoClient internalClient;

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
        this(mongoCrypt, keyRetriever, keyManagementService, kmsProviders, kmsProviderPropertySuppliers, false, null, null, null);
    }

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers, boolean bypassAutoEncryption, @Nullable CollectionInfoRetriever collectionInfoRetriever, @Nullable CommandMarker commandMarker, @Nullable MongoClient internalClient) {
        this.mongoCrypt = mongoCrypt;
        this.keyRetriever = keyRetriever;
        this.keyManagementService = keyManagementService;
        this.kmsProviders = kmsProviders;
        this.kmsProviderPropertySuppliers = kmsProviderPropertySuppliers;
        this.bypassAutoEncryption = bypassAutoEncryption;
        this.collectionInfoRetriever = collectionInfoRetriever;
        this.commandMarker = commandMarker;
        this.internalClient = internalClient;
    }

    public Mono<RawBsonDocument> encrypt(String databaseName, RawBsonDocument command2) {
        Assertions.notNull("databaseName", databaseName);
        Assertions.notNull("command", command2);
        if (this.bypassAutoEncryption) {
            return Mono.fromCallable(() -> command2);
        }
        return this.executeStateMachine(() -> this.mongoCrypt.createEncryptionContext(databaseName, (BsonDocument)command2), databaseName);
    }

    public Mono<RawBsonDocument> decrypt(RawBsonDocument commandResponse) {
        Assertions.notNull("commandResponse", commandResponse);
        return this.executeStateMachine(() -> this.mongoCrypt.createDecryptionContext((BsonDocument)commandResponse)).onErrorMap(this::wrapInClientException);
    }

    public Mono<RawBsonDocument> createDataKey(String kmsProvider, DataKeyOptions options) {
        Assertions.notNull("kmsProvider", kmsProvider);
        Assertions.notNull("options", options);
        return this.executeStateMachine(() -> this.mongoCrypt.createDataKeyContext(kmsProvider, MongoDataKeyOptions.builder().keyAltNames(options.getKeyAltNames()).masterKey(options.getMasterKey()).keyMaterial(options.getKeyMaterial()).build()));
    }

    public Mono<BsonBinary> encryptExplicitly(BsonValue value, EncryptOptions options) {
        Assertions.notNull("value", value);
        Assertions.notNull("options", options);
        return this.executeStateMachine(() -> {
            MongoExplicitEncryptOptions.Builder encryptOptionsBuilder = MongoExplicitEncryptOptions.builder().algorithm(options.getAlgorithm());
            if (options.getKeyId() != null) {
                encryptOptionsBuilder.keyId(options.getKeyId());
            }
            if (options.getKeyAltName() != null) {
                encryptOptionsBuilder.keyAltName(options.getKeyAltName());
            }
            if (options.getContentionFactor() != null) {
                encryptOptionsBuilder.contentionFactor(options.getContentionFactor());
            }
            if (options.getQueryType() != null) {
                encryptOptionsBuilder.queryType(options.getQueryType());
            }
            return this.mongoCrypt.createExplicitEncryptionContext(new BsonDocument("v", value), encryptOptionsBuilder.build());
        }).map(result2 -> result2.getBinary("v"));
    }

    public Mono<BsonValue> decryptExplicitly(BsonBinary value) {
        Assertions.notNull("value", value);
        return this.executeStateMachine(() -> this.mongoCrypt.createExplicitDecryptionContext(new BsonDocument("v", value))).map(result2 -> result2.get("v"));
    }

    public Mono<RawBsonDocument> rewrapManyDataKey(BsonDocument filter2, RewrapManyDataKeyOptions options) {
        return this.executeStateMachine(() -> this.mongoCrypt.createRewrapManyDatakeyContext(filter2, MongoRewrapManyDataKeyOptions.builder().provider(options.getProvider()).masterKey(options.getMasterKey()).build()));
    }

    @Override
    public void close() {
        try (MongoCrypt ignored = this.mongoCrypt;
             CommandMarker ignored1 = this.commandMarker;
             MongoClient ignored2 = this.internalClient;){
            KeyManagementService ignored3 = this.keyManagementService;
            if (ignored3 != null) {
                ignored3.close();
            }
        }
    }

    private Mono<RawBsonDocument> executeStateMachine(Supplier<MongoCryptContext> cryptContextSupplier) {
        return this.executeStateMachine(cryptContextSupplier, null);
    }

    private Mono<RawBsonDocument> executeStateMachine(Supplier<MongoCryptContext> cryptContextSupplier, @Nullable String databaseName) {
        try {
            MongoCryptContext cryptContext = cryptContextSupplier.get();
            return Mono.create(sink2 -> this.executeStateMachineWithSink(cryptContext, databaseName, (MonoSink<RawBsonDocument>)sink2)).doOnError(MongoCryptException.class, this::wrapInClientException).doFinally(s -> cryptContext.close());
        }
        catch (MongoCryptException e) {
            return Mono.error(this.wrapInClientException(e));
        }
    }

    private void executeStateMachineWithSink(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink2) {
        MongoCryptContext.State state = cryptContext.getState();
        switch (state) {
            case NEED_MONGO_COLLINFO: {
                this.collInfo(cryptContext, databaseName, sink2);
                break;
            }
            case NEED_MONGO_MARKINGS: {
                this.mark(cryptContext, databaseName, sink2);
                break;
            }
            case NEED_KMS_CREDENTIALS: {
                this.fetchCredentials(cryptContext, databaseName, sink2);
                break;
            }
            case NEED_MONGO_KEYS: {
                this.fetchKeys(cryptContext, databaseName, sink2);
                break;
            }
            case NEED_KMS: {
                this.decryptKeys(cryptContext, databaseName, sink2);
                break;
            }
            case READY: {
                sink2.success(cryptContext.finish());
                break;
            }
            case DONE: {
                sink2.success(EMPTY_RAW_BSON_DOCUMENT);
                break;
            }
            default: {
                sink2.error(new MongoInternalException("Unsupported encryptor state + " + state));
            }
        }
    }

    private void fetchCredentials(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink2) {
        try {
            cryptContext.provideKmsProviderCredentials(MongoCryptHelper.fetchCredentials(this.kmsProviders, this.kmsProviderPropertySuppliers));
            this.executeStateMachineWithSink(cryptContext, databaseName, sink2);
        }
        catch (Exception e) {
            sink2.error(e);
        }
    }

    private void collInfo(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink2) {
        if (this.collectionInfoRetriever == null) {
            sink2.error(new IllegalStateException("Missing collection Info retriever"));
        } else if (databaseName == null) {
            sink2.error(new IllegalStateException("Missing database name"));
        } else {
            this.collectionInfoRetriever.filter(databaseName, cryptContext.getMongoOperation()).doOnSuccess(result2 -> {
                if (result2 != null) {
                    cryptContext.addMongoOperationResult(result2);
                }
                cryptContext.completeMongoOperation();
                this.executeStateMachineWithSink(cryptContext, databaseName, sink2);
            }).doOnError(t -> sink2.error(MongoException.fromThrowableNonNull(t))).subscribe();
        }
    }

    private void mark(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink2) {
        if (this.commandMarker == null) {
            sink2.error(this.wrapInClientException(new MongoInternalException("Missing command marker")));
        } else if (databaseName == null) {
            sink2.error(this.wrapInClientException(new IllegalStateException("Missing database name")));
        } else {
            this.commandMarker.mark(databaseName, cryptContext.getMongoOperation()).doOnSuccess(result2 -> {
                cryptContext.addMongoOperationResult((BsonDocument)result2);
                cryptContext.completeMongoOperation();
                this.executeStateMachineWithSink(cryptContext, databaseName, sink2);
            }).doOnError(e -> sink2.error(this.wrapInClientException((Throwable)e))).subscribe();
        }
    }

    private void fetchKeys(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink2) {
        this.keyRetriever.find(cryptContext.getMongoOperation()).doOnSuccess(results -> {
            for (BsonDocument result2 : results) {
                cryptContext.addMongoOperationResult(result2);
            }
            cryptContext.completeMongoOperation();
            this.executeStateMachineWithSink(cryptContext, databaseName, sink2);
        }).doOnError(t -> sink2.error(MongoException.fromThrowableNonNull(t))).subscribe();
    }

    private void decryptKeys(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink2) {
        MongoKeyDecryptor keyDecryptor = cryptContext.nextKeyDecryptor();
        if (keyDecryptor != null) {
            this.keyManagementService.decryptKey(keyDecryptor).doOnSuccess(r -> this.decryptKeys(cryptContext, databaseName, sink2)).doOnError(e -> sink2.error(this.wrapInClientException((Throwable)e))).subscribe();
        } else {
            Mono.fromRunnable(() -> ((MongoCryptContext)cryptContext).completeKeyDecryptors()).doOnSuccess(r -> this.executeStateMachineWithSink(cryptContext, databaseName, sink2)).doOnError(e -> sink2.error(this.wrapInClientException((Throwable)e))).subscribe();
        }
    }

    private Throwable wrapInClientException(Throwable t) {
        return new MongoClientException("Exception in encryption library: " + t.getMessage(), t);
    }
}

