/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import java.io.Closeable;
import java.util.Map;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import reactor.core.publisher.Mono;

class CommandMarker
implements Closeable {
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings settings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled(mongoCrypt.getCryptSharedLibVersionString(), settings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map<String, Object> extraOptions = settings.getExtraOptions();
            boolean mongocryptdBypassSpawn = (Boolean)extraOptions.getOrDefault("mongocryptdBypassSpawn", false);
            if (!mongocryptdBypassSpawn) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder(extraOptions);
                MongoCryptHelper.startProcess(this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)extraOptions.get("mongocryptdURI")));
        }
    }

    Mono<RawBsonDocument> mark(String databaseName, RawBsonDocument command2) {
        if (this.client != null) {
            return this.runCommand(databaseName, command2).onErrorResume(Throwable.class, e -> {
                if (this.processBuilder == null) {
                    throw MongoException.fromThrowable(e);
                }
                return Mono.fromRunnable(() -> MongoCryptHelper.startProcess(this.processBuilder)).then(this.runCommand(databaseName, command2));
            }).onErrorMap(t -> new MongoClientException("Exception in encryption library: " + t.getMessage(), (Throwable)t));
        }
        return Mono.fromCallable(() -> command2);
    }

    private Mono<RawBsonDocument> runCommand(String databaseName, RawBsonDocument command2) {
        Assertions.assertNotNull(this.client);
        return Mono.from(this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)command2, RawBsonDocument.class));
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

