/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClientException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoServerException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.ClusteredIndexOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptionDefaults;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.operation.AsyncOperations;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CreateCollectionOperation;
import com.mongodb.internal.operation.CreateViewOperation;
import com.mongodb.internal.operation.DropDatabaseOperation;
import com.mongodb.internal.operation.IndexHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.OperationExecutor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public final class MongoOperationPublisher<T> {
    private final AsyncOperations<T> operations;
    private final UuidRepresentation uuidRepresentation;
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final OperationExecutor executor;
    private static final Function<BulkWriteResult, InsertOneResult> INSERT_ONE_RESULT_MAPPER = result2 -> {
        if (result2.wasAcknowledged()) {
            BsonValue insertedId = result2.getInserts().isEmpty() ? null : result2.getInserts().get(0).getId();
            return InsertOneResult.acknowledged(insertedId);
        }
        return InsertOneResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, InsertManyResult> INSERT_MANY_RESULT_MAPPER = result2 -> {
        if (result2.wasAcknowledged()) {
            return InsertManyResult.acknowledged(result2.getInserts().stream().collect(HashMap::new, (m, v) -> m.put(v.getIndex(), v.getId()), HashMap::putAll));
        }
        return InsertManyResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, DeleteResult> DELETE_RESULT_MAPPER = result2 -> {
        if (result2.wasAcknowledged()) {
            return DeleteResult.acknowledged(result2.getDeletedCount());
        }
        return DeleteResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, UpdateResult> UPDATE_RESULT_MAPPER = result2 -> {
        if (result2.wasAcknowledged()) {
            BsonValue upsertedId = result2.getUpserts().isEmpty() ? null : result2.getUpserts().get(0).getId();
            return UpdateResult.acknowledged(result2.getMatchedCount(), Long.valueOf(result2.getModifiedCount()), upsertedId);
        }
        return UpdateResult.unacknowledged();
    };

    MongoOperationPublisher(Class<T> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, UuidRepresentation uuidRepresentation, @Nullable AutoEncryptionSettings autoEncryptionSettings, OperationExecutor executor) {
        this(new MongoNamespace("_ignored", "_ignored"), documentClass, codecRegistry, readPreference, readConcern, writeConcern, retryWrites, retryReads, uuidRepresentation, autoEncryptionSettings, executor);
    }

    MongoOperationPublisher(MongoNamespace namespace, Class<T> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, UuidRepresentation uuidRepresentation, @Nullable AutoEncryptionSettings autoEncryptionSettings, OperationExecutor executor) {
        this.operations = new AsyncOperations<T>(namespace, Assertions.notNull("documentClass", documentClass), Assertions.notNull("readPreference", readPreference), Assertions.notNull("codecRegistry", codecRegistry), Assertions.notNull("readConcern", readConcern), Assertions.notNull("writeConcern", writeConcern), retryWrites, retryReads);
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.autoEncryptionSettings = autoEncryptionSettings;
        this.executor = Assertions.notNull("executor", executor);
    }

    MongoNamespace getNamespace() {
        return this.operations.getNamespace();
    }

    ReadPreference getReadPreference() {
        return this.operations.getReadPreference();
    }

    CodecRegistry getCodecRegistry() {
        return this.operations.getCodecRegistry();
    }

    ReadConcern getReadConcern() {
        return this.operations.getReadConcern();
    }

    WriteConcern getWriteConcern() {
        return this.operations.getWriteConcern();
    }

    public boolean getRetryWrites() {
        return this.operations.isRetryWrites();
    }

    public boolean getRetryReads() {
        return this.operations.isRetryReads();
    }

    Class<T> getDocumentClass() {
        return this.operations.getDocumentClass();
    }

    public AsyncOperations<T> getOperations() {
        return this.operations;
    }

    MongoOperationPublisher<T> withDatabase(String name) {
        return this.withDatabaseAndDocumentClass(name, this.getDocumentClass());
    }

    <D> MongoOperationPublisher<D> withDatabaseAndDocumentClass(String name, Class<D> documentClass) {
        return this.withNamespaceAndDocumentClass(new MongoNamespace(Assertions.notNull("name", name), "ignored"), Assertions.notNull("documentClass", documentClass));
    }

    MongoOperationPublisher<T> withNamespace(MongoNamespace namespace) {
        return this.withNamespaceAndDocumentClass(namespace, this.getDocumentClass());
    }

    <D> MongoOperationPublisher<D> withDocumentClass(Class<D> documentClass) {
        return this.withNamespaceAndDocumentClass(this.getNamespace(), documentClass);
    }

    <D> MongoOperationPublisher<D> withNamespaceAndDocumentClass(MongoNamespace namespace, Class<D> documentClass) {
        if (this.getNamespace().equals(namespace) && this.getDocumentClass().equals(documentClass)) {
            return this;
        }
        return new MongoOperationPublisher<D>(Assertions.notNull("namespace", namespace), Assertions.notNull("documentClass", documentClass), this.getCodecRegistry(), this.getReadPreference(), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    MongoOperationPublisher<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), CodecRegistries.withUuidRepresentation(Assertions.notNull("codecRegistry", codecRegistry), this.uuidRepresentation), this.getReadPreference(), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    MongoOperationPublisher<T> withReadPreference(ReadPreference readPreference) {
        if (this.getReadPreference().equals(readPreference)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), Assertions.notNull("readPreference", readPreference), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    MongoOperationPublisher<T> withWriteConcern(WriteConcern writeConcern) {
        if (this.getWriteConcern().equals(writeConcern)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), this.getReadPreference(), this.getReadConcern(), Assertions.notNull("writeConcern", writeConcern), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    MongoOperationPublisher<T> withReadConcern(ReadConcern readConcern) {
        if (this.getReadConcern().equals(readConcern)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), this.getReadPreference(), Assertions.notNull("readConcern", readConcern), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    Publisher<Void> dropDatabase(@Nullable ClientSession clientSession) {
        return this.createWriteOperationMono(() -> new DropDatabaseOperation(this.getNamespace().getDatabaseName(), this.getWriteConcern()), clientSession);
    }

    Publisher<Void> createCollection(@Nullable ClientSession clientSession, MongoNamespace namespace, CreateCollectionOptions options) {
        return this.createWriteOperationMono(() -> {
            ValidationOptions validationOptions;
            Bson validator;
            IndexOptionDefaults indexOptionDefaults;
            Bson storageEngine;
            Map<String, BsonDocument> encryptedFieldsMap;
            CreateCollectionOperation operation = new CreateCollectionOperation(namespace.getDatabaseName(), namespace.getCollectionName(), this.getWriteConcern()).capped(options.isCapped()).sizeInBytes(options.getSizeInBytes()).maxDocuments(options.getMaxDocuments()).storageEngineOptions(this.toBsonDocument(options.getStorageEngineOptions())).collation(options.getCollation()).expireAfter(options.getExpireAfter(TimeUnit.SECONDS)).timeSeriesOptions(options.getTimeSeriesOptions()).changeStreamPreAndPostImagesOptions(options.getChangeStreamPreAndPostImagesOptions());
            ClusteredIndexOptions clusteredIndexOptions = options.getClusteredIndexOptions();
            if (clusteredIndexOptions != null) {
                operation.clusteredIndexKey(this.toBsonDocument(clusteredIndexOptions.getKey()));
                operation.clusteredIndexUnique(clusteredIndexOptions.isUnique());
                operation.clusteredIndexName(clusteredIndexOptions.getName());
            }
            Bson encryptedFields = options.getEncryptedFields();
            operation.encryptedFields(this.toBsonDocument(encryptedFields));
            if (encryptedFields == null && this.autoEncryptionSettings != null && (encryptedFieldsMap = this.autoEncryptionSettings.getEncryptedFieldsMap()) != null) {
                operation.encryptedFields(encryptedFieldsMap.getOrDefault(namespace.getFullName(), null));
            }
            if ((storageEngine = (indexOptionDefaults = options.getIndexOptionDefaults()).getStorageEngine()) != null) {
                operation.indexOptionDefaults(new BsonDocument("storageEngine", this.toBsonDocument(storageEngine)));
            }
            if ((validator = (validationOptions = options.getValidationOptions()).getValidator()) != null) {
                operation.validator(this.toBsonDocument(validator));
            }
            if (validationOptions.getValidationLevel() != null) {
                operation.validationLevel(validationOptions.getValidationLevel());
            }
            if (validationOptions.getValidationAction() != null) {
                operation.validationAction(validationOptions.getValidationAction());
            }
            return operation;
        }, clientSession);
    }

    Publisher<Void> createView(@Nullable ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions options) {
        List<BsonDocument> bsonDocumentPipeline = this.createBsonDocumentList(Assertions.notNull("pipeline", pipeline));
        return this.createWriteOperationMono(() -> new CreateViewOperation(this.getNamespace().getDatabaseName(), Assertions.notNull("viewName", viewName), Assertions.notNull("viewOn", viewOn), bsonDocumentPipeline, this.getWriteConcern()).collation(Assertions.notNull("options", options).getCollation()), clientSession);
    }

    public <R> Publisher<R> runCommand(@Nullable ClientSession clientSession, Bson command2, ReadPreference readPreference, Class<R> clazz) {
        if (clientSession != null && clientSession.hasActiveTransaction() && !readPreference.equals(ReadPreference.primary())) {
            return Mono.error(new MongoClientException("Read preference in a transaction must be primary"));
        }
        return this.createReadOperationMono(() -> new CommandReadOperation(this.getNamespace().getDatabaseName(), this.toBsonDocument(Assertions.notNull("command", command2)), this.getCodecRegistry().get(Assertions.notNull("clazz", clazz))), clientSession, Assertions.notNull("readPreference", readPreference));
    }

    Publisher<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.createReadOperationMono(() -> this.operations.estimatedDocumentCount(Assertions.notNull("options", options)), null);
    }

    Publisher<Long> countDocuments(@Nullable ClientSession clientSession, Bson filter2, CountOptions options) {
        return this.createReadOperationMono(() -> this.operations.countDocuments(Assertions.notNull("filter", filter2), Assertions.notNull("options", options)), clientSession);
    }

    Publisher<BulkWriteResult> bulkWrite(@Nullable ClientSession clientSession, List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options) {
        return this.createWriteOperationMono(() -> this.operations.bulkWrite(Assertions.notNull("requests", requests), Assertions.notNull("options", options)), clientSession);
    }

    Publisher<InsertOneResult> insertOne(@Nullable ClientSession clientSession, T document, InsertOneOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.insertOne(Assertions.notNull("document", document), Assertions.notNull("options", options)), clientSession, WriteRequest.Type.INSERT).map(INSERT_ONE_RESULT_MAPPER);
    }

    Publisher<InsertManyResult> insertMany(@Nullable ClientSession clientSession, List<? extends T> documents, InsertManyOptions options) {
        return this.createWriteOperationMono(() -> this.operations.insertMany(Assertions.notNull("documents", documents), Assertions.notNull("options", options)), clientSession).map(INSERT_MANY_RESULT_MAPPER);
    }

    Publisher<DeleteResult> deleteOne(@Nullable ClientSession clientSession, Bson filter2, DeleteOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.deleteOne(Assertions.notNull("filter", filter2), Assertions.notNull("options", options)), clientSession, WriteRequest.Type.DELETE).map(DELETE_RESULT_MAPPER);
    }

    Publisher<DeleteResult> deleteMany(@Nullable ClientSession clientSession, Bson filter2, DeleteOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.deleteMany(Assertions.notNull("filter", filter2), Assertions.notNull("options", options)), clientSession, WriteRequest.Type.DELETE).map(DELETE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> replaceOne(@Nullable ClientSession clientSession, Bson filter2, T replacement, ReplaceOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.replaceOne(Assertions.notNull("filter", filter2), Assertions.notNull("replacement", replacement), Assertions.notNull("options", options)), clientSession, WriteRequest.Type.REPLACE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateOne(@Nullable ClientSession clientSession, Bson filter2, Bson update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateOne(Assertions.notNull("filter", filter2), Assertions.notNull("update", update), Assertions.notNull("options", options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateOne(@Nullable ClientSession clientSession, Bson filter2, List<? extends Bson> update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateOne(Assertions.notNull("filter", filter2), Assertions.notNull("update", update), Assertions.notNull("options", options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateMany(@Nullable ClientSession clientSession, Bson filter2, Bson update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateMany(Assertions.notNull("filter", filter2), Assertions.notNull("update", update), Assertions.notNull("options", options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateMany(@Nullable ClientSession clientSession, Bson filter2, List<? extends Bson> update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateMany(Assertions.notNull("filter", filter2), Assertions.notNull("update", update), Assertions.notNull("options", options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<T> findOneAndDelete(@Nullable ClientSession clientSession, Bson filter2, FindOneAndDeleteOptions options) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndDelete(Assertions.notNull("filter", filter2), Assertions.notNull("options", options)), clientSession);
    }

    Publisher<T> findOneAndReplace(@Nullable ClientSession clientSession, Bson filter2, T replacement, FindOneAndReplaceOptions options) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndReplace(Assertions.notNull("filter", filter2), Assertions.notNull("replacement", replacement), Assertions.notNull("options", options)), clientSession);
    }

    Publisher<T> findOneAndUpdate(@Nullable ClientSession clientSession, Bson filter2, Bson update, FindOneAndUpdateOptions options) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndUpdate(Assertions.notNull("filter", filter2), Assertions.notNull("update", update), Assertions.notNull("options", options)), clientSession);
    }

    Publisher<T> findOneAndUpdate(@Nullable ClientSession clientSession, Bson filter2, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndUpdate(Assertions.notNull("filter", filter2), Assertions.notNull("update", update), Assertions.notNull("options", options)), clientSession);
    }

    Publisher<Void> dropCollection(@Nullable ClientSession clientSession, DropCollectionOptions dropCollectionOptions) {
        return this.createWriteOperationMono(() -> this.operations.dropCollection(dropCollectionOptions, this.autoEncryptionSettings), clientSession);
    }

    Publisher<String> createIndex(@Nullable ClientSession clientSession, Bson key, IndexOptions options) {
        return this.createIndexes(clientSession, Collections.singletonList(new IndexModel(Assertions.notNull("key", key), options)), new CreateIndexOptions());
    }

    Publisher<String> createIndexes(@Nullable ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions options) {
        return this.createWriteOperationMono(() -> this.operations.createIndexes(Assertions.notNull("indexes", indexes), Assertions.notNull("options", options)), clientSession).thenMany(Flux.fromIterable(IndexHelper.getIndexNames(indexes, this.getCodecRegistry())));
    }

    Publisher<Void> dropIndex(@Nullable ClientSession clientSession, String indexName, DropIndexOptions options) {
        return this.createWriteOperationMono(() -> this.operations.dropIndex(Assertions.notNull("indexName", indexName), Assertions.notNull("options", options)), clientSession);
    }

    Publisher<Void> dropIndex(@Nullable ClientSession clientSession, Bson keys2, DropIndexOptions options) {
        return this.createWriteOperationMono(() -> this.operations.dropIndex(Assertions.notNull("keys", keys2), Assertions.notNull("options", options)), clientSession);
    }

    Publisher<Void> dropIndexes(@Nullable ClientSession clientSession, DropIndexOptions options) {
        return this.dropIndex(clientSession, "*", options);
    }

    Publisher<Void> renameCollection(@Nullable ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.createWriteOperationMono(() -> this.operations.renameCollection(Assertions.notNull("newCollectionNamespace", newCollectionNamespace), Assertions.notNull("options", options)), clientSession);
    }

    <R> Mono<R> createReadOperationMono(Supplier<AsyncReadOperation<R>> operation, @Nullable ClientSession clientSession) {
        return this.createReadOperationMono(operation, clientSession, this.getReadPreference());
    }

    <R> Mono<R> createReadOperationMono(Supplier<AsyncReadOperation<R>> operation, @Nullable ClientSession clientSession, ReadPreference readPreference) {
        AsyncReadOperation<R> readOperation = operation.get();
        return this.executor.execute(readOperation, readPreference, this.getReadConcern(), clientSession);
    }

    <R> Mono<R> createWriteOperationMono(Supplier<AsyncWriteOperation<R>> operation, @Nullable ClientSession clientSession) {
        AsyncWriteOperation<R> writeOperation = operation.get();
        return this.executor.execute(writeOperation, this.getReadConcern(), clientSession);
    }

    private Mono<BulkWriteResult> createSingleWriteRequestMono(Supplier<AsyncWriteOperation<BulkWriteResult>> operation, @Nullable ClientSession clientSession, WriteRequest.Type type) {
        return this.createWriteOperationMono(operation, clientSession).onErrorMap(MongoBulkWriteException.class, e -> {
            MongoServerException exception;
            WriteConcernError writeConcernError = e.getWriteConcernError();
            if (e.getWriteErrors().isEmpty() && writeConcernError != null) {
                WriteConcernResult writeConcernResult = type == WriteRequest.Type.INSERT ? WriteConcernResult.acknowledged(e.getWriteResult().getInsertedCount(), false, null) : (type == WriteRequest.Type.DELETE ? WriteConcernResult.acknowledged(e.getWriteResult().getDeletedCount(), false, null) : WriteConcernResult.acknowledged(e.getWriteResult().getMatchedCount() + e.getWriteResult().getUpserts().size(), e.getWriteResult().getMatchedCount() > 0, e.getWriteResult().getUpserts().isEmpty() ? null : e.getWriteResult().getUpserts().get(0).getId()));
                exception = new MongoWriteConcernException(writeConcernError, writeConcernResult, e.getServerAddress());
            } else {
                exception = !e.getWriteErrors().isEmpty() ? new MongoWriteException(new WriteError(e.getWriteErrors().get(0)), e.getServerAddress()) : new MongoWriteException(new WriteError(-1, "Unknown write error", new BsonDocument()), e.getServerAddress());
            }
            for (String errorLabel : e.getErrorLabels()) {
                exception.addLabel(errorLabel);
            }
            return exception;
        });
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        if (pipeline.contains(null)) {
            throw new IllegalArgumentException("pipeline can not contain a null value");
        }
        return pipeline.stream().map(this::toBsonDocument).collect(Collectors.toList());
    }

    public static <T> SingleResultCallback<T> sinkToCallback(MonoSink<T> sink2) {
        return (result2, t) -> {
            if (t != null) {
                sink2.error(t);
            } else if (result2 == null) {
                sink2.success();
            } else {
                sink2.success(result2);
            }
        };
    }

    @Nullable
    private BsonDocument toBsonDocument(@Nullable Bson document) {
        return document == null ? null : document.toBsonDocument(BsonDocument.class, this.getCodecRegistry());
    }
}

