/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcernResult;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;

final class FindAndModifyHelper {
    static <T> CommandOperationHelper.CommandWriteTransformer<BsonDocument, T> transformer() {
        return new CommandOperationHelper.CommandWriteTransformer<BsonDocument, T>(){

            @Override
            public T apply(BsonDocument result2, Connection connection) {
                return FindAndModifyHelper.transformDocument(result2, connection.getDescription().getServerAddress());
            }
        };
    }

    static <T> CommandOperationHelper.CommandWriteTransformerAsync<BsonDocument, T> asyncTransformer() {
        return new CommandOperationHelper.CommandWriteTransformerAsync<BsonDocument, T>(){

            @Override
            public T apply(BsonDocument result2, AsyncConnection connection) {
                return FindAndModifyHelper.transformDocument(result2, connection.getDescription().getServerAddress());
            }
        };
    }

    private static <T> T transformDocument(BsonDocument result2, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result2)) {
            MongoWriteConcernException writeConcernException = new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result2.getDocument("writeConcernError")), FindAndModifyHelper.createWriteConcernResult(result2.getDocument("lastErrorObject", new BsonDocument())), serverAddress);
            result2.getArray("errorLabels", new BsonArray()).stream().map(i2 -> i2.asString().getValue()).forEach(writeConcernException::addLabel);
            throw writeConcernException;
        }
        if (!result2.isDocument("value")) {
            return null;
        }
        return BsonDocumentWrapperHelper.toDocument(result2.getDocument("value", null));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument result2) {
        BsonBoolean updatedExisting = result2.getBoolean("updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result2.getNumber("n", new BsonInt32(0)).intValue(), updatedExisting.getValue(), result2.get("upserted"));
    }

    private FindAndModifyHelper() {
    }
}

