/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.SctpPacket;
import org.pcap4j.packet.namednumber.SctpChunkType;
import org.pcap4j.util.ByteArrays;

public final class IllegalSctpChunk
implements SctpPacket.SctpChunk {
    private static final long serialVersionUID = 7163848436153227901L;
    private final SctpChunkType type;
    private final byte[] rawData;

    public static IllegalSctpChunk newInstance(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalSctpChunk(rawData, offset, length);
    }

    private IllegalSctpChunk(byte[] rawData, int offset, int length) {
        this.type = SctpChunkType.getInstance(rawData[offset]);
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
    }

    private IllegalSctpChunk(Builder builder) {
        if (builder == null || builder.type == null || builder.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.type: ").append(builder.type).append(" builder.rawData: ").append(builder.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.type = builder.type;
        this.rawData = new byte[builder.rawData.length];
        System.arraycopy(builder.rawData, 0, this.rawData, 0, builder.rawData.length);
    }

    @Override
    public SctpChunkType getType() {
        return this.type;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Type: ").append(this.type);
        sb.append(", Illegal Raw Data: 0x").append(ByteArrays.toHexString(this.rawData, ""));
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Arrays.hashCode(this.rawData);
        result2 = 31 * result2 + this.type.hashCode();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IllegalSctpChunk other = (IllegalSctpChunk)obj;
        if (!Arrays.equals(this.rawData, other.rawData)) {
            return false;
        }
        return this.type.equals(other.type);
    }

    public static final class Builder {
        private SctpChunkType type;
        private byte[] rawData;

        public Builder() {
        }

        private Builder(IllegalSctpChunk obj) {
            this.type = obj.type;
            this.rawData = obj.rawData;
        }

        public Builder type(SctpChunkType type) {
            this.type = type;
            return this;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        public IllegalSctpChunk build() {
            return new IllegalSctpChunk(this);
        }
    }
}

