/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.commons.util;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lio/sip3/commons/util/IpUtil;", "", "()V", "convertIpv4ToString", "", "addr", "", "convertIpv6ToString", "convertToString", "findTheLongestZeroSequence", "Lkotlin/Pair;", "", "sip3-commons"})
public final class IpUtil {
    @NotNull
    public static final IpUtil INSTANCE = new IpUtil();

    private IpUtil() {
    }

    @NotNull
    public final String convertToString(@NotNull byte[] addr) {
        String string;
        Intrinsics.checkNotNullParameter(addr, "addr");
        switch (addr.length) {
            case 4: {
                string = this.convertIpv4ToString(addr);
                break;
            }
            case 16: {
                string = this.convertIpv6ToString(addr);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown IP address format: " + addr);
            }
        }
        return string;
    }

    private final String convertIpv4ToString(byte[] addr) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = RangesKt.until(0, 4);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int i2 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            byte v = UByte.constructor-impl(addr[i2]);
            sb.append(UByte.box-impl(v));
            if (i2 >= 3) continue;
            sb.append(".");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    private final String convertIpv6ToString(byte[] addr) {
        StringBuilder sb = new StringBuilder();
        Pair<Integer, Integer> pair = this.findTheLongestZeroSequence(addr);
        int j = ((Number)pair.component1()).intValue();
        int l = ((Number)pair.component2()).intValue();
        Iterable $this$forEach$iv = RangesKt.until(0, 8);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object[] objectArray;
            String string;
            int element$iv;
            int i2 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if (i2 == j) {
                sb.append("::");
                continue;
            }
            if (i2 >= j && i2 < j + l) continue;
            byte v1 = addr[i2 * 2];
            byte v2 = addr[i2 * 2 + 1];
            if (v1 == 0) {
                string = "%x";
                objectArray = new Object[]{v2};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                sb.append(string2);
            } else {
                string = "%x";
                objectArray = new Object[]{v1};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
                sb.append(string3);
                string = "%02x";
                objectArray = new Object[]{v2};
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string4, "format(this, *args)");
                sb.append(string4);
            }
            if (i2 == j - 1 || i2 >= 7) continue;
            sb.append(":");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    private final Pair<Integer, Integer> findTheLongestZeroSequence(byte[] addr) {
        int j1 = 0;
        j1 = -1;
        int l1 = 0;
        int j2 = 0;
        j2 = -1;
        int l2 = 0;
        boolean isZeroSequence = false;
        Iterable $this$forEach$iv = RangesKt.until(0, 8);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int i2 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if ((byte)(addr[i2 * 2] | addr[i2 * 2 + 1]) == 0) {
                if (!isZeroSequence) {
                    if (j2 != -1) {
                        if (l1 < l2) {
                            j1 = j2;
                            l1 = l2;
                        }
                        j2 = i2;
                        l2 = 1;
                    } else if (j1 != -1) {
                        j2 = i2;
                        ++l2;
                    } else {
                        j1 = i2;
                        ++l1;
                    }
                    isZeroSequence = true;
                    continue;
                }
                if (j2 != -1) {
                    ++l2;
                    continue;
                }
                ++l1;
                continue;
            }
            isZeroSequence = false;
        }
        return l1 < l2 ? new Pair<Integer, Integer>(j2, l2) : new Pair<Integer, Integer>(j1, l1);
    }
}

