/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.domain;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.domain.TcpSegment;
import io.sip3.captain.ce.pipeline.Handler;
import io.sip3.commons.domain.payload.ByteBufPayload;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\b&\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0016J \u0010 \u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\"2\b\b\u0002\u0010#\u001a\u00020\u0005H\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lio/sip3/captain/ce/domain/TcpConnection;", "", "handler", "Lio/sip3/captain/ce/pipeline/Handler;", "aggregationTimeout", "", "(Lio/sip3/captain/ce/pipeline/Handler;J)V", "getAggregationTimeout", "()J", "getHandler", "()Lio/sip3/captain/ce/pipeline/Handler;", "lastUpdated", "getLastUpdated", "setLastUpdated", "(J)V", "segments", "Ljava/util/TreeMap;", "Lio/sip3/captain/ce/domain/TcpSegment;", "getSegments", "()Ljava/util/TreeMap;", "assert", "", "buffer", "Lio/netty/buffer/ByteBuf;", "onTcpSegment", "", "sequenceNumber", "packet", "Lio/sip3/captain/ce/domain/Packet;", "processPreviousTcpSegment", "currentSegment", "processTcpSegments", "walkThroughTcpSegments", "sequenceNumbers", "", "nextSequenceNumber", "Companion", "sip3-captain-ce"})
public abstract class TcpConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Handler handler;
    private final long aggregationTimeout;
    private long lastUpdated;
    @NotNull
    private final TreeMap<Long, TcpSegment> segments;
    public static final short BUFFER_SIZE_THRESHOLD = Short.MAX_VALUE;

    public TcpConnection(@NotNull Handler handler, long aggregationTimeout) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.handler = handler;
        this.aggregationTimeout = aggregationTimeout;
        this.lastUpdated = System.currentTimeMillis();
        this.segments = new TreeMap();
    }

    @NotNull
    public final Handler getHandler() {
        return this.handler;
    }

    public final long getAggregationTimeout() {
        return this.aggregationTimeout;
    }

    public final long getLastUpdated() {
        return this.lastUpdated;
    }

    public final void setLastUpdated(long l) {
        this.lastUpdated = l;
    }

    @NotNull
    protected final TreeMap<Long, TcpSegment> getSegments() {
        return this.segments;
    }

    public abstract boolean assert(@NotNull ByteBuf var1);

    public final void onTcpSegment(long sequenceNumber, @NotNull Packet packet) {
        TcpSegment tcpSegment;
        Intrinsics.checkNotNullParameter(packet, "packet");
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull(payload, "null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        TcpSegment $this$onTcpSegment_u24lambda_u240 = tcpSegment = new TcpSegment();
        boolean bl = false;
        $this$onTcpSegment_u24lambda_u240.setSequenceNumber(sequenceNumber);
        $this$onTcpSegment_u24lambda_u240.setPacket(packet);
        $this$onTcpSegment_u24lambda_u240.setPayloadLength(buffer.readableBytes());
        TcpSegment segment = tcpSegment;
        Long l = sequenceNumber;
        ((Map)this.segments).put(l, segment);
        if (this.assert(buffer)) {
            this.processPreviousTcpSegment(segment);
        }
    }

    public void processTcpSegments() {
        List sequenceNumbers = new ArrayList();
        TcpConnection.walkThroughTcpSegments$default(this, sequenceNumbers, 0L, 2, null);
        while (!((Collection)sequenceNumbers).isEmpty()) {
            TcpSegment lastSegment;
            if (this.segments.get(CollectionsKt.last(sequenceNumbers)) == null) continue;
            if (lastSegment.getTimestamp() + this.aggregationTimeout < System.currentTimeMillis()) {
                CompositeByteBuf compositeBuffer = Unpooled.compositeBuffer();
                Iterable $this$forEach$iv = sequenceNumbers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    long sequenceNumber = ((Number)element$iv).longValue();
                    boolean bl = false;
                    TcpSegment segment = this.segments.remove(sequenceNumber);
                    if (segment == null) continue;
                    Payload payload = segment.getPacket().getPayload();
                    Intrinsics.checkNotNull(payload, "null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
                    Encodable payload2 = (Encodable)payload;
                    compositeBuffer.addComponent(true, payload2.encode());
                }
                Packet packet = lastSegment.getPacket();
                Intrinsics.checkNotNullExpressionValue(compositeBuffer, "compositeBuffer");
                packet.setPayload(new ByteBufPayload(compositeBuffer));
                this.handler.handle(packet);
            }
            sequenceNumbers.clear();
            this.walkThroughTcpSegments(sequenceNumbers, lastSegment.getSequenceNumber() + (long)lastSegment.getPayloadLength());
        }
    }

    protected final void walkThroughTcpSegments(@NotNull List<Long> sequenceNumbers, long nextSequenceNumber) {
        block5: {
            TcpSegment segment;
            Long sequenceNumber;
            block4: {
                Intrinsics.checkNotNullParameter(sequenceNumbers, "sequenceNumbers");
                Map.Entry<Long, TcpSegment> entry = this.segments.ceilingEntry(nextSequenceNumber);
                if (entry == null) {
                    return;
                }
                Map.Entry<Long, TcpSegment> entry2 = entry;
                sequenceNumber = entry2.getKey();
                segment = entry2.getValue();
                if (nextSequenceNumber == -1L) break block4;
                Long l = sequenceNumber;
                if (l == null || nextSequenceNumber != l) break block5;
            }
            Intrinsics.checkNotNullExpressionValue(sequenceNumber, "sequenceNumber");
            sequenceNumbers.add(sequenceNumber);
            this.walkThroughTcpSegments(sequenceNumbers, sequenceNumber + (long)segment.getPayloadLength());
        }
    }

    public static /* synthetic */ void walkThroughTcpSegments$default(TcpConnection tcpConnection, List list, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: walkThroughTcpSegments");
        }
        if ((n & 2) != 0) {
            l = -1L;
        }
        tcpConnection.walkThroughTcpSegments(list, l);
    }

    private final void processPreviousTcpSegment(TcpSegment currentSegment) {
        Map.Entry<Long, TcpSegment> entry = this.segments.lowerEntry(currentSegment.getSequenceNumber());
        if (entry == null) {
            return;
        }
        Map.Entry<Long, TcpSegment> entry2 = entry;
        Long sequenceNumber = entry2.getKey();
        TcpSegment segment = entry2.getValue();
        if (sequenceNumber + (long)segment.getPayloadLength() == currentSegment.getSequenceNumber()) {
            Packet packet = segment.getPacket();
            Payload payload = packet.getPayload();
            Intrinsics.checkNotNull(payload, "null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
            ByteBuf buffer = ((Encodable)payload).encode();
            if (this.assert(buffer)) {
                this.handler.handle(packet);
                this.segments.remove(sequenceNumber);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sip3/captain/ce/domain/TcpConnection$Companion;", "", "()V", "BUFFER_SIZE_THRESHOLD", "", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

