/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer.transform;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Count;
import com.newrelic.telemetry.micrometer.transform.AttributesMaker;
import com.newrelic.telemetry.micrometer.util.TimeTracker;
import io.micrometer.core.instrument.Meter;
import java.util.function.Function;

public class CommonCounterTransformer<T> {
    private final TimeTracker timeTracker;
    private final AttributesMaker attributesMaker;
    private final Function<T, CommonCounter> adapter;

    public CommonCounterTransformer(TimeTracker timeTracker, AttributesMaker attributesMaker, Function<T, CommonCounter> adapter) {
        this.timeTracker = timeTracker;
        this.attributesMaker = attributesMaker;
        this.adapter = adapter;
    }

    public Count transform(T micrometerCounter) {
        CommonCounter counter = this.adapter.apply(micrometerCounter);
        Attributes attributes = this.attributesMaker.make(counter.id(), counter.sourceType());
        long now = this.timeTracker.getCurrentTime();
        String name = counter.id().getName();
        return new Count(name, counter.count(), this.timeTracker.getPreviousTime(), now, attributes);
    }

    public static interface CommonCounter {
        public String sourceType();

        public Meter.Id id();

        public double count();
    }
}

