/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpPacket;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpV6Packet
extends AbstractPacket
implements IpPacket {
    private static final long serialVersionUID = 1837307843939979665L;
    private static final Logger logger = LoggerFactory.getLogger(IpV6Packet.class);
    private final IpV6Header header;
    private final Packet payload;

    public static IpV6Packet newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6Packet(rawData, offset, length);
    }

    private IpV6Packet(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int payloadLength;
        this.header = new IpV6Header(rawData, offset, length);
        int remainingRawDataLength = length - this.header.length();
        if (this.header.getPayloadLengthAsInt() == 0) {
            logger.debug("Total Length is 0. Assuming segmentation offload to be working.");
            payloadLength = remainingRawDataLength;
        } else {
            payloadLength = this.header.getPayloadLengthAsInt();
            if (payloadLength < 0) {
                throw new IllegalRawDataException("The value of payload length field seems to be wrong: " + this.header.getPayloadLengthAsInt());
            }
            if (payloadLength > remainingRawDataLength) {
                payloadLength = remainingRawDataLength;
            }
        }
        if (payloadLength != 0) {
            Packet nextPacket;
            PacketFactory<Packet, IpNumber> factory2 = PacketFactories.getFactory(Packet.class, IpNumber.class);
            Class<Packet> nextPacketClass = factory2.getTargetClass(this.header.getNextHeader());
            if (nextPacketClass.equals(factory2.getTargetClass())) {
                nextPacket = PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, offset + this.header.length(), payloadLength, NotApplicable.UNKNOWN_IP_V6_EXTENSION);
                if (nextPacket instanceof IllegalPacket) {
                    nextPacket = factory2.newInstance(rawData, offset + this.header.length(), payloadLength);
                }
            } else {
                nextPacket = factory2.newInstance(rawData, offset + this.header.length(), payloadLength, this.header.getNextHeader());
            }
            this.payload = nextPacket;
        } else {
            this.payload = null;
        }
    }

    private IpV6Packet(Builder builder) {
        if (builder == null || builder.version == null || builder.trafficClass == null || builder.flowLabel == null || builder.nextHeader == null || builder.srcAddr == null || builder.dstAddr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.version: ").append(builder.version).append(" builder.trafficClass: ").append(builder.trafficClass).append(" builder.flowLabel: ").append(builder.flowLabel).append(" builder.nextHeader: ").append(builder.nextHeader).append(" builder.srcAddr: ").append(builder.srcAddr).append(" builder.dstAddr: ").append(builder.dstAddr);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IpV6Header(builder, this.payload);
    }

    @Override
    public IpV6Header getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static interface IpV6FlowLabel
    extends Serializable {
        public int value();
    }

    public static interface IpV6TrafficClass
    extends Serializable {
        public byte value();
    }

    public static final class IpV6Header
    extends AbstractPacket.AbstractHeader
    implements IpPacket.IpHeader {
        private static final long serialVersionUID = 6587661877529988149L;
        private static final int VERSION_AND_TRAFFIC_CLASS_AND_FLOW_LABEL_OFFSET = 0;
        private static final int VERSION_AND_TRAFFIC_CLASS_AND_FLOW_LABEL_SIZE = 4;
        private static final int PAYLOAD_LENGTH_OFFSET = 4;
        private static final int PAYLOAD_LENGTH_SIZE = 2;
        private static final int NEXT_HEADER_OFFSET = 6;
        private static final int NEXT_HEADER_SIZE = 1;
        private static final int HOP_LIMIT_OFFSET = 7;
        private static final int HOP_LIMIT_SIZE = 1;
        private static final int SRC_ADDR_OFFSET = 8;
        private static final int SRC_ADDR_SIZE = 16;
        private static final int DST_ADDR_OFFSET = 24;
        private static final int DST_ADDR_SIZE = 16;
        private static final int IPV6_HEADER_SIZE = 40;
        private final IpVersion version;
        private final IpV6TrafficClass trafficClass;
        private final IpV6FlowLabel flowLabel;
        private final short payloadLength;
        private final IpNumber nextHeader;
        private final byte hopLimit;
        private final Inet6Address srcAddr;
        private final Inet6Address dstAddr;

        private IpV6Header(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 40) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build an IPv6 header(").append(40).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            int versionAndTrafficClassAndFlowLabel = ByteArrays.getInt(rawData, 0 + offset);
            this.version = IpVersion.getInstance((byte)(versionAndTrafficClassAndFlowLabel >>> 28));
            this.trafficClass = PacketFactories.getFactory(IpV6TrafficClass.class, NotApplicable.class).newInstance(new byte[]{(byte)((versionAndTrafficClassAndFlowLabel & 0xFF00000) >> 20)}, 0, 1);
            this.flowLabel = PacketFactories.getFactory(IpV6FlowLabel.class, NotApplicable.class).newInstance(rawData, 0 + offset, 4);
            this.payloadLength = ByteArrays.getShort(rawData, 4 + offset);
            this.nextHeader = IpNumber.getInstance(ByteArrays.getByte(rawData, 6 + offset));
            this.hopLimit = ByteArrays.getByte(rawData, 7 + offset);
            this.srcAddr = ByteArrays.getInet6Address(rawData, 8 + offset);
            this.dstAddr = ByteArrays.getInet6Address(rawData, 24 + offset);
        }

        private IpV6Header(Builder builder, Packet payload) {
            this.version = builder.version;
            this.trafficClass = builder.trafficClass;
            this.flowLabel = builder.flowLabel;
            this.nextHeader = builder.nextHeader;
            this.hopLimit = builder.hopLimit;
            this.srcAddr = builder.srcAddr;
            this.dstAddr = builder.dstAddr;
            this.payloadLength = builder.correctLengthAtBuild ? (payload != null ? (short)payload.length() : builder.payloadLength) : builder.payloadLength;
        }

        @Override
        public IpVersion getVersion() {
            return this.version;
        }

        public IpV6TrafficClass getTrafficClass() {
            return this.trafficClass;
        }

        public IpV6FlowLabel getFlowLabel() {
            return this.flowLabel;
        }

        public short getPayloadLength() {
            return this.payloadLength;
        }

        public int getPayloadLengthAsInt() {
            return 0xFFFF & this.payloadLength;
        }

        public IpNumber getNextHeader() {
            return this.nextHeader;
        }

        @Override
        public IpNumber getProtocol() {
            return this.nextHeader;
        }

        public byte getHopLimit() {
            return this.hopLimit;
        }

        public int getHopLimitAsInt() {
            return 0xFF & this.hopLimit;
        }

        @Override
        public Inet6Address getSrcAddr() {
            return this.srcAddr;
        }

        @Override
        public Inet6Address getDstAddr() {
            return this.dstAddr;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.version.value() << 28 | (0xFF & this.trafficClass.value()) << 20 | this.flowLabel.value()));
            rawFields.add(ByteArrays.toByteArray(this.payloadLength));
            rawFields.add(ByteArrays.toByteArray((Byte)this.nextHeader.value()));
            rawFields.add(ByteArrays.toByteArray(this.hopLimit));
            rawFields.add(ByteArrays.toByteArray(this.srcAddr));
            rawFields.add(ByteArrays.toByteArray(this.dstAddr));
            return rawFields;
        }

        @Override
        public int length() {
            return 40;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[IPv6 Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Version: ").append(this.version).append(ls);
            sb.append("  Traffic Class: ").append(this.trafficClass).append(ls);
            sb.append("  Flow Label: ").append(this.flowLabel).append(ls);
            sb.append("  Payload length: ").append(this.getPayloadLengthAsInt()).append(" [bytes]").append(ls);
            sb.append("  Next Header: ").append(this.nextHeader).append(ls);
            sb.append("  Hop Limit: ").append(this.getHopLimitAsInt()).append(ls);
            sb.append("  Source address: ").append(this.srcAddr).append(ls);
            sb.append("  Destination address: ").append(this.dstAddr).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IpV6Header other = (IpV6Header)obj;
            return this.srcAddr.equals(other.srcAddr) && this.dstAddr.equals(other.dstAddr) && this.payloadLength == other.payloadLength && this.hopLimit == other.hopLimit && this.nextHeader.equals(other.nextHeader) && this.trafficClass.equals(other.trafficClass) && this.flowLabel.equals(other.flowLabel) && this.version.equals(other.version);
        }

        @Override
        protected int calcHashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.version.hashCode();
            result2 = 31 * result2 + this.trafficClass.hashCode();
            result2 = 31 * result2 + this.flowLabel.hashCode();
            result2 = 31 * result2 + this.payloadLength;
            result2 = 31 * result2 + this.nextHeader.hashCode();
            result2 = 31 * result2 + this.hopLimit;
            result2 = 31 * result2 + this.srcAddr.hashCode();
            result2 = 31 * result2 + this.dstAddr.hashCode();
            return result2;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<IpV6Packet> {
        private IpVersion version;
        private IpV6TrafficClass trafficClass;
        private IpV6FlowLabel flowLabel;
        private short payloadLength;
        private IpNumber nextHeader;
        private byte hopLimit;
        private Inet6Address srcAddr;
        private Inet6Address dstAddr;
        private Packet.Builder payloadBuilder;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        public Builder(IpV6Packet packet) {
            this.version = packet.header.version;
            this.trafficClass = packet.header.trafficClass;
            this.flowLabel = packet.header.flowLabel;
            this.payloadLength = packet.header.payloadLength;
            this.nextHeader = packet.header.nextHeader;
            this.hopLimit = packet.header.hopLimit;
            this.srcAddr = packet.header.srcAddr;
            this.dstAddr = packet.header.dstAddr;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder version(IpVersion version) {
            this.version = version;
            return this;
        }

        public Builder trafficClass(IpV6TrafficClass trafficClass) {
            this.trafficClass = trafficClass;
            return this;
        }

        public Builder flowLabel(IpV6FlowLabel flowLabel) {
            this.flowLabel = flowLabel;
            return this;
        }

        public Builder payloadLength(short payloadLength) {
            this.payloadLength = payloadLength;
            return this;
        }

        public Builder nextHeader(IpNumber nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder hopLimit(byte hopLimit) {
            this.hopLimit = hopLimit;
            return this;
        }

        public Builder srcAddr(Inet6Address srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public Builder dstAddr(Inet6Address dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6Packet build() {
            return new IpV6Packet(this);
        }
    }
}

