/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpV4InternetTimestampOptionFlag;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.util.ByteArrays;

public final class IpV4InternetTimestampOption
implements IpV4Packet.IpV4Option {
    private static final long serialVersionUID = -7218329498227977405L;
    private final IpV4OptionType type = IpV4OptionType.INTERNET_TIMESTAMP;
    private final byte length;
    private final byte pointer;
    private final byte overflow;
    private final IpV4InternetTimestampOptionFlag flag;
    private final IpV4InternetTimestampOptionData data;

    public static IpV4InternetTimestampOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV4InternetTimestampOption(rawData, offset, length);
    }

    private IpV4InternetTimestampOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 4) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[offset] != (Byte)this.getType().value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1 + offset];
        int lengthFieldAsInt = this.getLengthAsInt();
        if (length < lengthFieldAsInt) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data is too short to build this option(").append(this.getLengthAsInt()).append("). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (lengthFieldAsInt < 4) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The length field value must be equal or more than 4 but it is: ").append(lengthFieldAsInt);
            throw new IllegalRawDataException(sb.toString());
        }
        if (lengthFieldAsInt % 4 != 0) {
            throw new IllegalRawDataException("Invalid length for this option: " + lengthFieldAsInt);
        }
        this.pointer = rawData[2 + offset];
        this.overflow = (byte)((rawData[3 + offset] & 0xF0) >> 4);
        this.flag = IpV4InternetTimestampOptionFlag.getInstance((byte)(rawData[3 + offset] & 0xF));
        this.data = lengthFieldAsInt > 4 ? PacketFactories.getFactory(IpV4InternetTimestampOptionData.class, IpV4InternetTimestampOptionFlag.class).newInstance(rawData, 4 + offset, lengthFieldAsInt - 4, this.flag) : null;
    }

    private IpV4InternetTimestampOption(Builder builder) {
        if (builder == null || builder.flag == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.flag: ").append(builder.flag);
            throw new NullPointerException(sb.toString());
        }
        this.pointer = builder.pointer;
        this.overflow = builder.overflow;
        this.flag = builder.flag;
        this.data = builder.data;
        this.length = builder.correctLengthAtBuild ? (byte)this.length() : builder.length;
    }

    @Override
    public IpV4OptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte getPointer() {
        return this.pointer;
    }

    public int getPointerAsInt() {
        return 0xFF & this.pointer;
    }

    public byte getOverflow() {
        return this.overflow;
    }

    public int getOverflowAsInt() {
        return 0xFF & this.overflow;
    }

    public IpV4InternetTimestampOptionFlag getFlag() {
        return this.flag;
    }

    public IpV4InternetTimestampOptionData getData() {
        return this.data;
    }

    @Override
    public int length() {
        return 4 + (this.data != null ? this.data.length() : 0);
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        rawData[2] = this.pointer;
        rawData[3] = (Byte)this.flag.value();
        rawData[3] = (byte)(rawData[3] | this.overflow << 4);
        if (this.data != null) {
            System.arraycopy(this.data.getRawData(), 0, rawData, 4, this.data.length());
        }
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[option-type: ").append(this.getType());
        sb.append("] [option-length: ").append(this.getLengthAsInt());
        sb.append(" bytes] [pointer: ").append(this.getPointerAsInt());
        sb.append("] [overflow: ").append(this.getOverflowAsInt());
        sb.append("] [flag: ").append(this.flag).append("]");
        if (this.data != null) {
            sb.append(" [data: ").append(this.data).append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV4InternetTimestampOption other = (IpV4InternetTimestampOption)obj;
        if (this.length == other.length && this.pointer == other.pointer && this.overflow == other.overflow && this.flag.equals(other.flag)) {
            if (this.data == null) {
                return other.data == null;
            }
            return this.data.equals(other.data);
        }
        return false;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.length;
        result2 = 31 * result2 + this.pointer;
        result2 = 31 * result2 + this.overflow;
        result2 = 31 * result2 + this.flag.hashCode();
        if (this.data != null) {
            result2 = 31 * result2 + this.data.hashCode();
        }
        return result2;
    }

    public static interface IpV4InternetTimestampOptionData
    extends Serializable {
        public int length();

        public byte[] getRawData();
    }

    public static final class Builder
    implements LengthBuilder<IpV4InternetTimestampOption> {
        private byte length;
        private byte pointer;
        private byte overflow;
        private IpV4InternetTimestampOptionFlag flag;
        private IpV4InternetTimestampOptionData data;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(IpV4InternetTimestampOption option) {
            this.length = option.length;
            this.pointer = option.pointer;
            this.overflow = option.overflow;
            this.flag = option.flag;
            this.data = option.data;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder pointer(byte pointer) {
            this.pointer = pointer;
            return this;
        }

        public Builder overflow(byte overflow) {
            this.overflow = overflow;
            return this;
        }

        public Builder flag(IpV4InternetTimestampOptionFlag flag) {
            this.flag = flag;
            return this;
        }

        public Builder data(IpV4InternetTimestampOptionData data) {
            this.data = data;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV4InternetTimestampOption build() {
            return new IpV4InternetTimestampOption(this);
        }
    }
}

